<?php
// include './private/db_connect.php';

// Database configuration 127.0.0.1:80
$localDbHost = "localhost";
$localDbUser = "root";
$localDbPass = "";
$localDbName = "shapers_db"; // Change to your local database name

// Connect to Local Database
$localConn = new mysqli($localDbHost, $localDbUser, $localDbPass, $localDbName);
if ($localConn->connect_error) {
    die("Local Database Connection failed: " . $localConn->connect_error);
}

// Function to check internet connectivity
function isInternetAvailable() {
    $connected = @fsockopen("www.google.com", 80);
    if ($connected) {
        fclose($connected);
        return true;
    }
    return false;
}

// If internet is available, sync data
if (isInternetAvailable()) {
    echo "Internet available, syncing data...\n";

    // Select unsynced records
    $query = "SELECT * FROM supplier_list WHERE synced = 0";
    $result = $localConn->query($query);

    if ($result->num_rows > 0) {
        $data = [];
        while ($row = $result->fetch_assoc()) {
            $data[] = $row;
        }

        // Send data to online API
        $ch = curl_init("https://onielapp.com/demo/private/sync_api.php");
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
        curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
        
        $response = curl_exec($ch);
        curl_close($ch);

        // Decode response and update synced status
        $responseData = json_decode($response, true);
        if (isset($responseData["status"]) && $responseData["status"] == "success") {
            $localConn->query("UPDATE supplier_list SET synced = 1 WHERE synced = 0");
        }
    } else {
        echo "No new data to sync.\n";
    }
} else {
    echo "No internet connection.\n";
}

$localConn->close();
?>