<?php
    include('./private/db_connect.php');
?>

<?php

function fillMissingFields($row, $fields) {
    foreach ($fields as $field) {
        if (!array_key_exists($field, $row) || $row[$field] === null) {
            $row[$field] = "";
        }
    }

    return $row;
}

if (isset($_GET['barcode'])) {
    $barcode = $_GET['barcode'];

    // Prepare the SQL query using the provided barcode
    $stmt = $conn->prepare("SELECT product_list.name, product_list.sku, product_list.id AS product_id, product_list.cost_price, product_list.price, ms.total_bal, product_list.price2, product_list.price3
    FROM main_store ms
    LEFT JOIN product_list ON ms.product_id = product_list.id
    WHERE product_list.sku = ?
    LIMIT 1");

    // Bind the barcode parameter to the prepared statement
    $stmt->bind_param("s", $barcode);

    // Execute the prepared statement
    $stmt->execute();

    // Bind the result variables
    $stmt->bind_result($name, $sku, $product_id, $cost_price, $price, $total_bal, $price2, $price3);

    // Fetch the result
    $stmt->fetch();

    // Check for errors during query execution
    if ($stmt->error) {
        $error = 'error|'.$stmt->error;
        echo $error;
        exit;
    }

    // Create an associative array from the fetched variables
    $row = [
        'name' => $name,
        'sku' => $sku,       
        'product_id' => $product_id,
        'cost_price' => $cost_price,
        'price' => $price,
        'total_bal' => $total_bal,
        'price2' => $price2,
        'price3' => $price3,
    ];

    // List of fields to fill with empty string if missing
    $fields = ['name', 'sku', 'product_id', 'cost_price', 'price', 'price2', 'price3', 'total_bal'];

    // Fill missing fields with empty string
    $row = fillMissingFields($row, $fields);

    // Convert the associative array to pipe-delimited string
    $response = implode('|', $row);

    echo $response;

    // Make sure to exit the script after sending the response
    exit;
    
    
    } else {
        // No results found, return an appropriate string
        echo 'no_results';
    }
?>