<?php

session_start(); 

include __DIR__ . '/db_connect.php';

if (isset($_POST['sale_date'])) {
    $sale_date = date("Y-m-d", strtotime($_POST['sale_date']));
    $store_id = $_SESSION['login_store_id']; // Get user store
    $acct_type = $_SESSION['login_type']; // Get Login type
    $i = 1;
    $total_discount = $total_vat = $total_profit = $total_valuation = $total_amount = 0;

    // Build condition for store filter
    $store_condition = "";
    if ($acct_type != 1 && $acct_type != 11) {
        $store_condition = "AND i.store_id = '$store_id'";
    }

    // Fetch sales data based on the selected date and account type
    $query = $conn->query("
        SELECT i.ref_no, i.date_updated, s.user_id, s.discount_amt, SUM(i.amount) AS total_amount, SUM(i.qty) AS total_qty, 
               u.names AS user_name
        FROM inventory i 
        JOIN sales_list s ON i.ref_no = s.ref_no
        JOIN users u ON s.user_id = u.id
        WHERE i.type = 2 $store_condition AND DATE(i.date_updated) = '$sale_date'
        GROUP BY i.ref_no, DATE(i.date_updated)
        ORDER BY i.date_updated DESC
    ");

    $output = "";

    while ($row = $query->fetch_assoc()) {
        $ref_no = $row['ref_no'];
        $date_updated = date("d-M-Y", strtotime($row['date_updated']));
        $total_amount += $row['total_amount'];
        $total_qty = $row['total_qty'];
        $user_name = $row['user_name'];
        $discount = $row['discount_amt'];

        // Cost valuation query condition
        $valuation_condition = "";
        if ($acct_type != 1 && $acct_type != 11) {
            $valuation_condition = "AND i.store_id = '$store_id'";
        }

        // Calculate valuation
        $valuation = 0;
        $product_query = $conn->query("
            SELECT i.product_id, i.qty, p.cost_price 
            FROM inventory i
            JOIN product_list p ON i.product_id = p.id
            WHERE i.ref_no = '$ref_no' $valuation_condition AND i.type = 2
        ");
        while ($prod = $product_query->fetch_assoc()) {
            $valuation += $prod['cost_price'] * $prod['qty'];
        }

        // Profit calculation
        $profit = $row['total_amount'] - $valuation;
        $profit_percentage = ($valuation > 0) ? (($profit / $valuation) * 100) : 0;

        // Update cumulative totals
        $total_profit += $profit;
        $total_valuation += $valuation;

        $output .= "<tr>
            <td class='text-center'>{$i}</td>
            <td class='text-left'>{$user_name}</td>
            <td class='text-left'>Sales</td>
            <td class='text-right'>₦" . number_format($discount, 2) . "</td>
            <td class='text-right'>₦0.00</td>
            <td class='text-right'>" . number_format($profit_percentage, 2) . "%</td>
            <td class='text-right'>₦" . number_format($profit, 2) . "</td>
            <td class='text-right'>₦" . number_format($valuation, 2) . "</td>
            <td class='text-right'>₦" . number_format($row['total_amount'], 2) . "</td>
        </tr>";

        $i++; 
    }

    // Add footer row
    $output .= "<tr style='font-weight: bold;'>
        <td colspan='6' class='text-right'>Total:</td>
        <td class='text-right'>₦" . number_format($total_profit, 2) . "</td>
        <td class='text-right'>₦" . number_format($total_valuation, 2) . "</td>
        <td class='text-right'>₦" . number_format($total_amount, 2) . "</td>
    </tr>";

    echo $output;
}
?>