<?php 
require './private/db_connect.php';

$i = 1;
$total_sales = 0;
$cum_sales1 = 0; 
$total_cash = 0; 
$total_pos = 0;
$total_stransfer = 0;

$acct_type = $_SESSION['login_type']; // Get account type
$store_id = $_SESSION['login_store_id']; // Get user store

if (isset($_POST['search'])) {
    $date1 = date("Y-m-d", strtotime($_POST['date1']));
    $date2 = date("Y-m-d", strtotime($_POST['date2']));
    $store = $_POST['store_id'];

    $query = $conn->prepare("
        SELECT s.store_name, sl.date_updated, sl.cash, sl.pos, sl.transfer 
        FROM sales_list sl
        INNER JOIN stores s ON sl.store_id = s.id
        WHERE DATE(sl.date_updated) BETWEEN ? AND ? AND sl.store_id = ?
        ORDER BY sl.date_updated DESC
    ");
    $query->bind_param("ssi", $date1, $date2, $store);
    $query->execute();
    $result = $query->get_result();

} else {
    // Prepare date range for past 7 days
    $today = date("Y-m-d");
    $week_ago = date("Y-m-d", strtotime("-14 days"));

    if ($acct_type == 1 || $acct_type == 11) {
        // Admin: load all data in past 7 days (any store)
        $query = $conn->prepare("
            SELECT s.store_name, sl.date_updated, sl.cash, sl.pos, sl.transfer 
            FROM sales_list sl
            INNER JOIN stores s ON sl.store_id = s.id
            WHERE DATE(sl.date_updated) BETWEEN ? AND ?
            ORDER BY sl.date_updated DESC
        ");
        $query->bind_param("ss", $week_ago, $today);
    } else {
        // Non-admin: only data from user's store in past 7 days
        $query = $conn->prepare("
            SELECT s.store_name, sl.date_updated, sl.cash, sl.pos, sl.transfer 
            FROM sales_list sl
            INNER JOIN stores s ON sl.store_id = s.id
            WHERE DATE(sl.date_updated) BETWEEN ? AND ? AND sl.store_id = ?
            ORDER BY sl.date_updated DESC
        ");
        $query->bind_param("ssi", $week_ago, $today, $store_id);
    }

    $query->execute();
    $result = $query->get_result();
}

if ($result->num_rows > 0) {
    while ($fetch = $result->fetch_assoc()) {
        $total_sales = $fetch['cash'] + $fetch['pos'] + $fetch['transfer'];
        $cum_sales1 += $total_sales;

        // Add to the respective totals
        $total_cash += $fetch['cash'];
        $total_pos += $fetch['pos'];
        $total_stransfer += $fetch['transfer'];
?>
<tr>
    <td class="text-center"><?php echo $i++; ?></td> 
    <td class=""><?php echo date("d-M-Y", strtotime($fetch['date_updated'])); ?></td>
    <td class="text-right"><?php echo "&#8358; " . number_format($fetch['cash'], 2); ?></td>
    <td class="text-right"><?php echo "&#8358; " . number_format($fetch['pos'], 2); ?></td>
    <td class="text-right"><?php echo "&#8358; " . number_format($fetch['transfer'], 2); ?></td>
    <td class="text-right"><?php echo "&#8358; " . number_format($total_sales, 2); ?></td>
</tr>
<?php
    }
} else {
    echo '
    <tr>
        <td colspan="7"><center>Record Not Found</center></td>
    </tr>';
}
?>