
<!DOCTYPE html>
<html lang="en">

<head>
    <link rel="stylesheet" href=https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/css/bootstrap.min.css>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>NUBAN</title>
</head>
<body>

<section class="content">
<div class="container-fluid">
<div class="card-body">
<form action="" method="POST">
    <br/>
    <div class="row">
        <div class="col-md-3">
            <label class="control-label">Select Bank</label>
            <select name="code" id="code" class="form-control form-control-sm custom-select browser-default select">
                <option value="120001"> 9mobile 9Payment Service Bank</option><option value="801"> Abbey Mortgage Bank</option><option value="51204"> Above Only MFB</option><option value="51312"> Abulesoro MFB</option><option value="044"> Access Bank</option><option value="063"> Access Bank (Diamond)</option><option value="602"> Accion Microfinance Bank</option><option value="50036"> Ahmadu Bello University Microfinance Bank</option><option value="120004"> Airtel Smartcash PSB</option><option value="51336"> AKU Microfinance Bank</option><option value="035A"> ALAT by WEMA</option><option value="090629"> Amegy Microfinance Bank</option><option value="50926"> Amju Unique MFB</option><option value="51341"> AMPERSAND MICROFINANCE BANK</option><option value="50083"> Aramoko MFB</option><option value="401"> ASO Savings and Loans</option><option value="MFB50094"> Astrapolaris MFB LTD</option><option value="51229"> Bainescredit MFB</option>
                <option value="50117"> Banc Corp Microfinance Bank</option><option value="50931"> Bowen Microfinance Bank</option><option value="FC40163"> Branch International Financial Services Limited</option><option value="565"> Carbon</option><option value="865"> CASHCONNECT MFB</option><option value="50823"> CEMCS Microfinance Bank</option><option value="50171"> Chanelle Microfinance Bank Limited</option><option value="312"> Chikum Microfinance bank</option><option value="023"> Citibank Nigeria</option><option value="50910"> Consumer Microfinance Bank</option><option value="50204"> Corestep MFB</option><option value="559"> Coronation Merchant Bank</option><option value="FC40128"> County Finance Limited</option><option value="51297"> Crescent MFB</option><option value="50162"> Dot Microfinance Bank</option><option value="050"> Ecobank Nigeria</option><option value="50263"> Ekimogun MFB</option><option value="098"> Ekondo Microfinance Bank</option>
                <option value="50126"> Eyowo</option><option value="51318"> Fairmoney Microfinance Bank</option><option value="070"> Fidelity Bank</option><option value="51314"> Firmus MFB</option><option value="011"> First Bank of Nigeria</option><option value="214"> First City Monument Bank</option><option value="413"> FirstTrust Mortgage Bank Nigeria</option><option value="50315"> FLOURISH MFB</option><option value="501"> FSDH Merchant Bank Limited</option><option value="812"> Gateway Mortgage Bank LTD</option><option value="00103"> Globus Bank</option><option value="100022"> GoMoney</option><option value="50739"> Goodnews Microfinance Bank</option><option value="562"> Greenwich Merchant Bank</option><option value="058"> Guaranty Trust Bank</option><option value="51251"> Hackman Microfinance Bank</option>
                <option value="50383"> Hasal Microfinance Bank</option><option value="030"> Heritage Bank</option><option value="120002"> HopePSB</option><option value="51244"> Ibile Microfinance Bank</option><option value="50439"> Ikoyi Osun MFB</option><option value="50442"> Ilaro Poly Microfinance Bank</option><option value="50453"> Imowo MFB</option><option value="50457"> Infinity MFB</option><option value="301"> Jaiz Bank</option><option value="50502"> Kadpoly MFB</option><option value="082"> Keystone Bank</option><option value="50200"> Kredi Money MFB LTD</option><option value="50211"> Kuda Bank</option><option value="90052"> Lagos Building Investment Company Plc.</option><option value="50549"> Links MFB</option><option value="031"> Living Trust Mortgage Bank</option><option value="303"> Lotus Bank</option><option value="50563"> Mayfair MFB</option><option value="50304"> Mint MFB</option><option value="50515"> Moniepoint MFB</option>
                <option value="120003"> MTN Momo PSB</option><option value="00711"> OPay Digital Services Limited (OPay)</option><option value="107"> Optimus Bank Limited</option><option value="100002"> Paga</option><option value="999991"> PalmPay</option><option value="104"> Parallex Bank</option><option value="311"> Parkway - ReadyCash</option><option value="999992"> Paycom</option><option value="50743"> Peace Microfinance Bank</option><option value="51146"> Personal Trust MFB</option><option value="50746"> Petra Mircofinance Bank Plc</option><option value="268"> Platinum Mortgage Bank</option><option value="076"> Polaris Bank</option><option value="50864"> Polyunwana MFB</option><option value="105"> PremiumTrust Bank</option><option value="101"> Providus Bank</option><option value="51293"> QuickFund MFB</option><option value="502"> Rand Merchant Bank</option><option value="90067"> Refuge Mortgage Bank</option><option value="50994"> Rephidim Microfinance Bank</option>
                <option value="51286"> Rigo Microfinance Bank Limited</option><option value="50767"> ROCKSHIELD MICROFINANCE BANK</option><option value="125"> Rubies MFB</option><option value="51113"> Safe Haven MFB</option><option value="951113"> Safe Haven Microfinance Bank Limited</option><option value="40165"> SAGE GREY FINANCE LIMITED</option><option value="50582"> Shield MFB</option><option value="51062"> Solid Allianze MFB</option><option value="50800"> Solid Rock MFB</option><option value="51310"> Sparkle Microfinance Bank</option><option value="221"> Stanbic IBTC Bank</option><option value="068"> Standard Chartered Bank</option><option value="51253"> Stellas MFB</option><option value="232"> Sterling Bank</option><option value="100"> Suntrust Bank</option>
                <option value="50968"> Supreme MFB</option><option value="302"> TAJ Bank</option><option value="090560"> Tanadi Microfinance Bank</option><option value="51269"> Tangerine Money</option><option value="51211"> TCF MFB</option><option value="102"> Titan Bank</option><option value="100039"> Titan Paystack</option><option value="50840"> U&C Microfinance Bank Ltd (U AND C MFB)</option><option value="MFB51322"> Uhuru MFB</option><option value="50870"> Unaab Microfinance Bank Limited</option><option value="50871"> Unical MFB</option><option value="51316"> Unilag Microfinance Bank</option><option value="032"> Union Bank of Nigeria</option><option value="033"> United Bank For Africa</option><option value="215"> Unity Bank</option><option value="566"> VFD Microfinance Bank Limited</option><option value="51355"> Waya Microfinance Bank</option><option value="035"> Wema Bank</option><option value="057"> Zenith Bank</option>
            </select>
        </div>
        <div class="col-sm-3">
            <label class="control-label" for="barcode">Account Number</label>
            <div class="input-group input-group-sm">
                <input type="text" class="form-control form-control-sm text-left"  name="account_number" id="account_number" required>
                
            </div>
        </div>
        <div class="col-md-2">
            <br/>
            <button type="submit" name="search" class="btn btn-block btn-sm btn-primary">Confirm NUBAN</button>
        </div>
        
    </div>
    <br/>
</form>
<div class="col-md-12">
<?php

    if(isset($_POST['search']))
    {
        $account_number = $_POST['account_number'];
        $code = $_POST['code'];

    /**
     * Makes an API call using cURL.
     *
     * @param string $method The HTTP method (POST, PUT, GET).
     * @param string $url The API URL.
     * @param mixed $data The data to be sent with the request.
     * @return mixed The API response.
     * @throws Exception If the cURL request fails.
     */
    function callAPI($method, $url, $data) {
        $curl = curl_init();

        // Set cURL options based on the HTTP method
        switch ($method) {
            case "POST":
                curl_setopt($curl, CURLOPT_POST, 1);
                if ($data)
                    curl_setopt($curl, CURLOPT_POSTFIELDS, $data);
                break;
            case "PUT":
                curl_setopt($curl, CURLOPT_CUSTOMREQUEST, "PUT");
                if ($data)
                    curl_setopt($curl, CURLOPT_POSTFIELDS, $data);
                break;
            default:
                if ($data)
                    $url = sprintf("%s?%s", $url, http_build_query($data));
        }

        // Set common cURL options
        curl_setopt_array($curl, [
            CURLOPT_URL => $url,
            CURLOPT_HTTPHEADER => ['Content-Type: application/json'],
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_HTTPAUTH => CURLAUTH_BASIC
        ]);

        

        // Execute the cURL request
        $result = curl_exec($curl);

        // Check for cURL errors
        if ($result === false) {
            $error = curl_error($curl);
            curl_close($curl);
            throw new Exception("cURL Request Failed: $error");
        }

        curl_close($curl);

        return $result;
    }

    // Define the API endpoint URL
    $url = 'https://maylancer.org/api/nuban/api.php';

    // Set the API parameters
    $params = [
        'account_number' => $account_number,
        'bank_code' => $code
    ];

    try {
        // Make the API call
        $get_data = callAPI('GET', $url, $params);

        // Decode the API response
        $response = json_decode($get_data, true);

        // Process the API response
        if (isset($response['account_name'])) {
            $name = explode(' ', $response['account_name']);
            $firstName = $name[0];
            $lastName = end($name);

            // $data = [
                // "firstname" => $firstName,
                // "lastname" => $lastName,
                // "account_name" => $response['account_name'],
                // "account_number" => $response['account_number'],
                // "bank_name" => $response['Bank_name'],
                // "status" => 'success'
            // ];
        } else {
            $errorMessage = 'Invalid account number entered, ' . $response['message'];

            $data = [
                "message" => $errorMessage,
                "status" => 'error'
            ];
        }

        // Output the result as JSON
        // echo json_encode($data, JSON_PRETTY_PRINT);
    } catch (Exception $e) {
        // Handle cURL exceptions
        $errorMessage = $e->getMessage();

        // $data = [
        //     "message" => "API Request Error: $errorMessage",
        //     "status" => 'error'
        // ];

        echo json_encode($data, JSON_PRETTY_PRINT);
    }
   
?>
    <div class="row">
        <div class="col-md-3">
            <label class="control-label">Account Name:</label>
            <input type="text" class="form-control form-control-sm text-right" value="<?= $response['account_name']; ?>" readonly>
        </div>
        
        <div class="col-md-3">
            <label class="control-label">Account Number:</label>
            <input type="text" class="form-control form-control-sm text-right" value="<?= $response['account_number']; ?>" readonly>
        </div>
        
        <div class="col-md-3">
            <label class="control-label">Bank Name:</label>
            <input type="text" class="form-control form-control-sm text-right" value="<?= $response['Bank_name']; ?>" readonly>
        </div>
    </div>

    <?php
        } else {
            echo '<script>alert("No Record Found")</script>'; 
        } 
    ?>  
</div>

</div>
</div>
</section>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/js/bootstrap.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/js/bootstrap.bundle.min.js"></script>

<script   src="https://code.jquery.com/jquery-3.7.0.min.js"   integrity="sha256-2Pmvv0kuTBOenSvLm6bvfBSSHrUJ+3A7x6P5Ebd07/g="   crossorigin="anonymous"></script>

<script src="https://code.jquery.com/ui/1.13.1/jquery-ui.min.js" integrity="sha256-eTyxS0rkjpLEo16uXTS0uVCS4815lc40K2iVpWDvdSY=" crossorigin="anonymous"></script>

    
</body>
</html>