<?php include('./private/db_connect.php');?>

<div class="wrapper">
<div class="content-wrapper">
	<div class="container-fluid">

		<div class="content-header">
		<div class="container-fluid">
			<div class="row mb-2">
			<div class="col-sm-6">
				<h1 class="m-0">Onielsoft | Martvet</h1>
			</div><!-- /.col -->
			<div class="col-sm-6">
				<ol class="breadcrumb float-sm-right">
				<li class="breadcrumb-item"><a href="index.php">Home</a></li>
				<li class="breadcrumb-item active">Move Product</li>
				</ol>
			</div><!-- /.col -->
			</div><!-- /.row -->
		</div><!-- /.container-fluid -->
		</div>
		<div class="col-md-12">
		<div class="card card-outline card-warning">
			<div class="card-header">
				<h2 class="card-title"><b>Move Product to Another Store</b></h2>

				<div class="card-tools">
				<button type="button" class="btn btn-tool" data-card-widget="collapse">
					<i class="fas fa-minus"></i>
				</button>
				<button type="button" class="btn btn-tool" data-card-widget="remove">
					<i class="fas fa-times"></i>
				</button>
				</div>
			</div>			
			<div class="card-body">
				<form action="" id="move-product">
					<!--<input type="hidden" name="ref_no" value="</?php echo isset($ref_no) ? $ref_no : '' ?>"> -->
					<input type="hidden" id="store_id" name="store_id" value="<?php echo ($_SESSION['login_store_id']) ?>">
					<div class="col-md-12">
						<div class="row mb-3">
							<div class="form-group col-md-3">
							
							<label class="control-label">Sending Store</label>
								<select name="sstore_id" id="" class="custom-select browser-default select2">
									<option value=""></option>
									<?php 
										$store = $conn->query("SELECT * FROM stores order by store_name asc");
										while($row=$store->fetch_assoc()):
									?>
									<option value="<?php echo $row['id'] ?>"><?php echo $row['store_name'] ?></option>
									<?php endwhile; ?>
								</select>
							</div>

							<div class="form-group col-md-3">
							
							<label class="control-label">Receiving Store</label>
								<select name="rstore_id" id="" class="custom-select browser-default select2">
									<option value=""></option>
									<?php 
										$store = $conn->query("SELECT * FROM stores order by store_name asc");
										while($row=$store->fetch_assoc()):
									?>
									<option value="<?php echo $row['id'] ?>"><?php echo $row['store_name'] ?></option>
									<?php endwhile; ?>
								</select>
							</div>
						</div>
						<hr>
						<div class="row mb-3">
								<div class="col-md-4">
									<label class="control-label">Product</label>
									<select name="" id="product" class="custom-select browser-default select2">
										<option value=""></option>
									<?php 
									$cat = $conn->query("SELECT * FROM category_list order by name asc");
										while($row=$cat->fetch_assoc()):
											$cat_arr[$row['id']] = $row['name'];
										endwhile;
									$product = $conn->query("SELECT * FROM product_list WHERE store_id = '".$_SESSION['login_store_id']."' order by name asc");
									while($row=$product->fetch_assoc()):
										$prod[$row['id']] = $row;
									?>
										<option value="<?php echo $row['id'] ?>" data-name="<?php echo $row['name'] ?>" data-description="<?php echo $row['description'] ?>"><?php echo $row['name'] . ' | ' . $row['sku'] ?></option>
									<?php endwhile; ?>
									</select>
								</div>
								<div class="col-md-2">
									<label class="control-label">Qty</label>
									<input type="number" class="form-control text-right" step="any" id="qty" >
								</div>
								<div class="col-md-3">
									<label class="control-label">&nbsp</label>
									<button class="btn btn-block btn-sm btn-info" type="button" id="add_list"><i class="fa fa-plus"></i> Add to List</button>
								</div>


						</div>
						<div class="row">
							<table class="table table-bordered" id="list">
								<thead>
									<tr>
										<th class="text-center">Product</th>
										<th class="text-center">Qty</th>
										<th class="text-center">Action</th>
									</tr>
								</thead>
								<tbody>
									<?php 
									if(isset($id)):
									while($row = $inv->fetch_assoc()): 
										foreach(json_decode($row['other_details']) as $k=>$v){
											$row[$k] = $v;
										}
									?>
										<tr class="item-row">
											<td>
												<input type="hidden" name="product_id[]" value="<?php echo $row['product_id'] ?>">
												<!-- <input type="hidden" name="ref-no[]" value="</?php echo $row['ref-no'] ?>"> -->
												<p class="pname">Name: <b><?php echo $prod[$row['product_id']]['name'] ?></b></p>
												<p class="pdesc"><small><i>Description: <b><?php echo $prod[$row['product_id']]['description'] ?></b></i></small></p>
											</td>
											<td>
												<input type="number" min="1" step="any" name="qty[]" value="<?php echo $row['qty'] ?>" class="text-right">
											</td>
											<td class="text-center">
												<buttob class="btn btn-sm btn-danger" onclick = "rem_list($(this))"><i class="fa fa-trash"></i></buttob>
											</td>
										</tr>
									<?php endwhile; ?>
									<?php endif; ?>
								</tbody>
								
							</table>
						</div>
						<div class="col-md-4">
							<button class="btn btn-primary btn-sm btn-block float-right .col-md-3">Save</button>
						</div>
					</div>
				</form>
			</div>
			
		</div>
	</div>
</div>
</div>
<div id="tr_clone">
	<table>
	<tr class="item-row">
		<td>
			<input type="hidden" name="product_id[]" value="">
			<!--<input type="hidden" name="ref_no[]" value=""> -->
			<p class="pname">Name: <b>product</b></p>
			<p class="pdesc"><small><i>Description: <b>Description</b></i></small></p>
		</td>
		<td>
			<input type="number" min="1" step="any" name="qty[]" value="" class="text-right">
		</td>
		
		<td class="text-center">
			<buttob class="btn btn-sm btn-danger" onclick = "rem_list($(this))"><i class="fa fa-trash"></i></buttob>
		</td>
	</tr>
	</table>
</div>


<style type="text/css">
	#tr_clone{
		display: none;
	}
	td{
		vertical-align: middle;
	}
	td p {
		margin: unset;
	}
	td input[type='number']{
		height: calc(100%);
		width: calc(100%);

	}
	input[type=number]::-webkit-inner-spin-button, 
	input[type=number]::-webkit-outer-spin-button { 
	  -webkit-appearance: none; 
	  margin: 0; 
	} 
</style>

<script>
	$('#add_list').click(function(){
   
    // Check if a product is selected and quantity is entered
    var product = $('#product').val(),
        qty = $('#qty').val();
    
    if (product === '' || qty === '') {
        alert("Please complete the fields first", 'danger');
        return false;
    }

    // Check if the product already exists in the list
    if ($('#list').find('tr[data-id="' + product + '"]').length > 0) {
        alert("Product already on the list", 'danger');
        return false;
    }

    // Clone the row and update it with product and qty
    var tr = $('<tr class="item-row" data-id="' + product + '"></tr>');
    
    tr.append('<td>' +
        '<input type="hidden" name="product_id[]" value="' + product + '">' +
        '<p class="pname">Name: <b>' + $("#product option[value='" + product + "']").attr('data-name') + '</b></p>' +
        '<p class="pdesc"><small><i>Description: <b>' + $("#product option[value='" + product + "']").attr('data-description') + '</b></i></small></p>' +
        '</td>');

    tr.append('<td><input type="number" min="1" step="any" name="qty[]" value="' + qty + '" class="text-right"></td>');

    tr.append('<td class="text-center"><button class="btn btn-sm btn-danger" onclick="rem_list($(this))"><i class="fa fa-trash"></i></button></td>');

    // Append the new row to the table body
    $('#list tbody').append(tr);

    // Clear the form fields
    $('#product').val('').trigger('change'); // Reset select2
    $('#qty').val('');
});

</script>

<script>
	$('.select2').select2({
	 	placeholder:"Please select here",
	 	width:"100%"
	})

	function rem_list(_this){
		_this.closest('tr').remove()
	}
</script>

<script>
	$('#move-product').submit(function(e){
		e.preventDefault();
		start_load();

		// Check for at least one product
		if ($("#list .item-row").length <= 0) {
			alert("Please insert at least 1 item in the cart.", 'danger');
			end_load();
			return false;
		}

		// Remove any existing hidden inputs to avoid duplicates
		$(this).find('input[name="product_ids"]').remove();
		$(this).find('input[name="qtys"]').remove();

		// Gather product and qty values
		var product_ids = [];
		var qtys = [];

		$("#list .item-row").each(function(){
			product_ids.push($(this).find('[name="product_id[]"]').val());
			qtys.push($(this).find('[name="qty[]"]').val());
		});

		// Append hidden inputs to the form
		$('<input>').attr({
			type: 'hidden',
			name: 'product_ids',
			value: product_ids.join(',')
		}).appendTo('#move-product');

		$('<input>').attr({
			type: 'hidden',
			name: 'qtys',
			value: qtys.join(',')
		}).appendTo('#move-product');

		// Submit via AJAX
		$.ajax({
			url: 'ajax.php?action=save_move_product',
			method: 'POST',
			data: $(this).serialize(),
			success: function(resp) {
				console.log("Server Response:", resp); // <-- Add this for debugging
				if (resp.trim() == "1") {
					alert("Data successfully moved to another store!", 'success');
					setTimeout(function(){
						location.href = "index.php?page=move_product";
					}, 1500);
				} else if (resp.toLowerCase().includes("sql error") || resp.toLowerCase().includes("debug")) {
					alert("Server Error: " + resp, 'danger');
				} else {
					alert("Error processing data. Server Response: " + resp, 'danger');
				}
				end_load();
			}

			// success: function(resp) {
				// if (resp == 1) {
					// alert("Data successfully moved to another store!", 'success');
					// setTimeout(function(){
						// location.href = "index.php?page=move_product";
					// }, 1500);
				// } else {
					// alert("Error processing data. Please check your inputs.", 'danger');
				// }
				// end_load();
			// },
			// error: function() {
				// alert("An error occurred while sending the data.", 'danger');
				// end_load();
			// }
		});
	});

</script>