<?php 
	session_start();
	include './private/db_connect.php';

?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Onielsoft Martvet | Log in</title>

  <!-- Google Font: Source Sans Pro -->
  <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700&display=fallback">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="plugins/fontawesome-free/css/all.min.css">
  <!-- icheck bootstrap -->
  <link rel="stylesheet" href="plugins/icheck-bootstrap/icheck-bootstrap.min.css">
  <!-- Theme style -->
  <link rel="stylesheet" href="dist/css/adminlte.min.css">
  <link rel="shortcut icon" href="./images/pos.jpg"> 

  <?php 
    // if(isset($_SESSION['login_id']))
    // header("location:index.php");

	if(isset($_SESSION['login_id']))
		header("location:index.php?page=home");

    // $query = $conn->query("SELECT * FROM system_settings limit 1")->fetch_array();
    //     foreach ($query as $key => $value) {
    //       if(!is_numeric($key))
    //         $_SESSION['setting_'.$key] = $value;
    //     }
    ?>
</head>
<body class="hold-transition login-page">
<div class="login-box">
  <!-- /.login-logo -->
  <div class="card card-outline card-primary">
    <div class="card-header text-center">
      <a href="index.php" class="h1"><b>Martvet</b> | ePOS</a>
    </div>
    <div class="card-body">
      <p class="login-box-msg">Sign in to start your session</p>

      
      <form id="login-form" >
      <!-- <form method="POST"> -->
        <div class="input-group mb-3">
          <input type="text" id="username" name="username" class="form-control" placeholder="User Name">
          <div class="input-group-append">
            <div class="input-group-text">
              <span class="fas fa-envelope"></span>
            </div>
          </div>
        </div>
        <div class="input-group mb-3">
          <input type="password" id="password" name="password" class="form-control" placeholder="Password">
          <div class="input-group-append">
            <div class="input-group-text">
              <span class="fas fa-lock"></span>
            </div>
          </div>
        </div>
        <div class="row">
          <div class="col-8">
            <div class="icheck-primary">
              <input type="checkbox" id="remember">
              <label for="remember">
                Remember Me
              </label>
            </div>
          </div>
          <!-- /.col -->
          <div class="col-4">
            <!-- <button type="submit" class="btn btn-primary btn-block">Sign In</button> -->
			<button class="btn-sm btn-block btn-wave col-md-12 btn-primary" name="login">Login</button>
            <!-- <button class="btn btn-primary btn-block">Sign In</button> -->
          </div>
          <!-- /.col -->
        </div>
      </form>

      <div class="social-auth-links text-center mt-2 mb-3">
        <a href="#" class="btn btn-block btn-primary">
          <!--<i class="fab fa-facebook mr-2"></i> Sign in using Facebook-->
        </a>
        <a href="#" class="btn btn-block btn-warning">
          <!--<i class="fab fa-google-plus mr-2"></i> Sign in using Google+-->
        </a>
      </div>
      <!-- /.social-auth-links -->

      <p class="mb-1">
        <a href="#">I forgot my password</a>
      </p>
      <p class="mb-0">
        <a href="#" class="text-center">Register a new membership</a>
      </p>
    </div>
    <!-- /.card-body -->
  </div>
  <!-- /.card -->
</div>
<!-- /.login-box -->

<!-- jQuery -->
<script src="plugins/jquery/jquery.min.js"></script>
<!-- Bootstrap 4 -->
<script src="plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
<!-- AdminLTE App -->
<script src="dist/js/adminlte.min.js"></script>
</body>

<script>
	
		$('#login-form').submit(function(e){
			e.preventDefault()
			$('#login-form button[type="button"]').attr('disabled',true).html('Logging in...');
			if($(this).find('.alert-danger').length > 0 )
				$(this).find('.alert-danger').remove();
			$.ajax({
				url:'ajax.php?action=login',
				method:'POST',
				data:$(this).serialize(),
				error:err=>{
					console.log(err)
						
					$('#login-form button[type="button"]').removeAttr('disabled').html('Login');

              },
              success:function(resp){
                  if(resp == 1){
                          location.href ='index.php?page=home';
                      }else if(resp == 2){
                          location.href ='home_2.php';
                              
                      }else{
                          $('#login-form').prepend('<div class="alert alert-danger">Username or password is incorrect.</div>')
                          $('#login-form button[type="button"]').removeAttr('disabled').html('Login');
                          }
                  }
              })  

		})
</script>	
</html>