
<?php
  session_start();
  include './private/db_connect.php';

?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Onielsoft Martvet | Lockscreen</title>

  <!-- Google Font: Source Sans Pro -->
  <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700&display=fallback">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="./plugins/fontawesome-free/css/all.min.css">
  <!-- Theme style -->
  <link rel="stylesheet" href="./dist/css/adminlte.min.css">
   <link rel="shortcut icon" href="./images/pos.jpg"> 
</head>
<body class="hold-transition lockscreen">
<!-- Automatic element centering -->
<div class="lockscreen-wrapper">
  <div class="lockscreen-logo">
    <a href="#">Onielsoft | <b>Martvet</b></a>
  </div>
  <!-- User name -->
  <div class="lockscreen-name"><?php echo $_SESSION['login_names'] ?></div>

  <!-- START LOCK SCREEN ITEM -->
  <div class="lockscreen-item">
    <!-- lockscreen image -->
    <div class="lockscreen-image">
      <img src="./dist/img/martvet.png" alt="User Image">
    </div>
    <!-- /.lockscreen-image -->

    <!-- lockscreen credentials (contains the form) -->
    
    <form class="lockscreen-credentials" id="login-form" >
      <div class="input-group">
        <input type="hidden" id="username" name="username" value="<?php echo ($_SESSION['login_username']) ?>"> 
        <input type="password" id="password" name="password" class="form-control" placeholder="password">

        <div class="input-group-append">
          <button type="button" class="btn" name="login">
            <i class="fas fa-arrow-right text-muted"></i>
          </button>
        </div>
      </div>
    </form>
    <!-- /.lockscreen credentials -->

  </div>
  <!-- /.lockscreen-item -->
  <div class="help-block text-center">
    Enter your password to retrieve your session
  </div>
  <div class="text-center">
    <a href="ajax.php?action=logout">Or sign in as a different user</a>
  </div>
  <div class="lockscreen-footer text-center">
    Copyright &copy; 2020 - <?php echo date("Y");?> <b><a href="https://onielng.com" target="_blank" class="text-black">O'niel Communication Innovation</a></b><br>
    All rights reserved
  </div>
</div>
<!-- /.center -->

<!-- jQuery -->
<script src="./plugins/jquery/jquery.min.js"></script>
<!-- Bootstrap 4 -->
<script src="./plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
</body>

<script>
	
		$('#login-form').submit(function(e){
			e.preventDefault()
			$('#login-form button[type="button"]').attr('disabled',true).html('Logging in...');
			if($(this).find('.alert-danger').length > 0 )
				$(this).find('.alert-danger').remove();
			$.ajax({
				url:'ajax.php?action=login',
				method:'POST',
				data:$(this).serialize(),
				error:err=>{
					console.log(err)
						
					$('#login-form button[type="button"]').removeAttr('disabled').html('Login');

                    },
                    success:function(resp){
                        if(resp == 1){
                                location.href ='index.php?page=home';
                            }else if(resp == 2){
                                // location.href ='home_2.php';
                                    
                            }else{
                                $('#login-form').prepend('<div class="alert alert-danger">Username or password is incorrect.</div>')
                                $('#login-form button[type="button"]').removeAttr('disabled').html('Login');
                                }
                        }
                    })  


		})
</script>	
</html>