<?php include './private/db_connect.php' ?> 

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>



<div class="wrapper">
<div class="content-wrapper">
	<div class="container-fluid">

		<div class="content-header">
		<div class="container-fluid">
			<div class="row mb-2">
			<div class="col-sm-6">
				<h1 class="m-0">Onielsoft | Martvet</h1>
			</div><!-- /.col -->
			<div class="col-sm-6">
				<ol class="breadcrumb float-sm-right">
				<li class="breadcrumb-item"><a href="index.php">Home</a></li>
				<li class="breadcrumb-item active">Stoke Inventory</li>
				</ol>
			</div><!-- /.col -->
			</div><!-- /.row -->
		</div><!-- /.container-fluid -->
		</div>

<div class="col-lg-12">
<div class="row">
    <div class="col-md-12">
    <div class="card card-outline card-warning">
			<div class="card-header">
				<h2 class="card-title"><b>General Stock Inventory</b></h2>

				<div class="card-tools">
				<button type="button" class="btn btn-tool" data-card-widget="collapse">
					<i class="fas fa-minus"></i>
				</button>
				<button type="button" class="btn btn-tool" data-card-widget="remove">
					<i class="fas fa-times"></i>
				</button>
				</div>
			</div>
      <div class="card-body">
        <div class="col-md-12">
					<div class="card-body">
            <table class="table table-bordered table-hover" id="load_table">
						<!-- <thead class="alert-info"> -->
              <!-- <table class="table table-bordered"> -->
                <thead>
                  <th class="text-center">#</th>
                  <th class="text-center">SKU</th>
                  <th class="text-center">Product</th>
                  <th class="text-center">Stock In</th>
                  <!-- <th class="text-center">Received</th> -->
                  <th class="text-center">Sales</th>
                  <!-- <th class="text-center">Stock Out</th> -->
                  <th class="text-center">Stock Available</th>
                  <th class="text-center">Cost Value</th>
                  <th class="text-center">Sales Value</th>
                </thead>
                  <tbody>
                    <?php 
                      $i = 1;
                      $product = $conn->query("SELECT * FROM product_list order by name asc");
                      while($row=$product->fetch_assoc()):
                      // Stock In quantity and cost value
                      $stock_in = $conn->query("SELECT sum(qty) as inn, sum(qty * cprice) as cost_value FROM inventory where type = 1 and product_id = ".$row['id']);
                      $stock_in_data = $stock_in->fetch_assoc();
                      $inn = $stock_in_data ? $stock_in_data['inn'] : 0;
                      $cost_value = $stock_in_data ? $stock_in_data['cost_value'] : 0;

                      // Sales quantity and value
                      $sales = $conn->query("SELECT sum(qty) as `out`, sum(qty * sprice) as sales_value FROM inventory where type = 2 and product_id = ".$row['id']);
                      $sales_data = $sales->fetch_assoc();
                      $out = $sales_data ? $sales_data['out'] : 0;
                      $sales_value = $sales_data ? $sales_data['sales_value'] : 0;

                      $available = $inn - $out;

                    ?>
                    <tr>
                      <td class="text-center"><?php echo $i++ ?></td>
                      <td class="text-center clickable-sku" data-product-id="<?php echo $row['id'] ?>" style="cursor: pointer; color: #007bff; text-decoration: underline;"><?php echo $row['sku'] ?></td>
                      <td class=""><?php echo $row['name'] ?></td>
                      <td class="text-right"><?php echo $inn ?></td>
                      <!-- <td class="text-right"><?php echo $sinn ?></td> -->
                      <td class="text-right"><?php echo number_format($out, 2) ?></td>
                      <td class="text-right"><?php echo number_format($available, 2) ?></td>
                      <td class="text-right">₦<?php echo number_format($cost_value, 2) ?></td>
                      <td class="text-right">₦<?php echo number_format($sales_value, 2) ?></td>
                    </tr>
                    <?php endwhile; ?>
                  </tbody>
              </table>
          </div>
        </div>
			</div>
			
			<div class="modal fade" id="view_product" role='dialog'>
				<div class="modal-dialog modal-md" role="document">
					<div class="modal-content">
						<div class="modal-body">
							<div class="container-fluid">
								<div class="row">
									<div class="form-group col-md-6">
										<label for="" class="control-label">Barcode/SKU:</label>
										<div class="input-group input-group-sm">
											<input type="text" class="form-control form-control-sm text-left" id="sku" name="sku">
										</div>
										<div class="form-group col-md-6">
											<label for="" class="control-label">Category:</label>
											<input type="text" class="form-control form-control-sm text-left" name="category" id="category">
										</div>
									</div>
									
								</div>
								<div class="form-group">
									<label for="" class="control-label">Product Name:</label>
									<input type="text" class="form-control form-control-sm text-left" name="p_name" id="p_name">
								</div>
								<div class="row">
									
									<div class="form-group col-md-6">
										<label for="" class="control-label">Cost Price:</label>
										<input type="text" class="form-control form-control-sm text-left" name="cost_price" id="cost_price">
									</div>
									<div class="form-group col-md-6">
										<label class="control-label">Selling Price:</label>
										<input type="number" class="form-control form-control-sm text-right" id="price" name="price">
									</div>
								</div>

								<div class="row">
									<div class="col-sm-6">
										<div class="form-group">
											<label id="textbox3_label" class="control-label">Selling Price 2:</label>
											<input type="number" step="any" class="form-control form-control-sm text-right" id="price2" name="price2">
										</div>
									</div>
									<div class="col-sm-6">
										<div class="form-group">
											<label id="textbox4_label" class="control-label">Selling Price 3:</label>
											<input type="number" step="any" class="form-control form-control-sm text-right" id="price3" name="price3">
										</div>
									</div>
								</div>
							</div>
							<!--<div class="modal-footer">
								<button type="button" class="btn btn-warning" data-dismiss="modal">Close</button>
							</div>-->
						</div>
				</div>
			</div>
		</div>
</div>
</div>
</div>
</div>
<script type="text/javascript" src="https://cdn.datatables.net/buttons/1.6.5/js/dataTables.buttons.min.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/buttons/1.6.5/js/buttons.print.min.js"></script>

<!-- jQuery -->
<script src="./plugins/jquery/jquery.min.js"></script>
<!-- Bootstrap 4 -->
<script src="./plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
<!-- DataTables  & Plugins -->
<script src="./plugins/datatables/jquery.dataTables.min.js"></script>
<script src="./plugins/datatables-bs4/js/dataTables.bootstrap4.min.js"></script>
<script src="./plugins/datatables-responsive/js/dataTables.responsive.min.js"></script>
<script src="./plugins/datatables-responsive/js/responsive.bootstrap4.min.js"></script>
<script src="./plugins/datatables-buttons/js/dataTables.buttons.min.js"></script>
<script src="./plugins/datatables-buttons/js/buttons.bootstrap4.min.js"></script>
<script src="./plugins/jszip/jszip.min.js"></script>
<script src="./plugins/pdfmake/pdfmake.min.js"></script>
<script src="./plugins/pdfmake/vfs_fonts.js"></script>
<script src="./plugins/datatables-buttons/js/buttons.html5.min.js"></script>
<script src="./plugins/datatables-buttons/js/buttons.print.min.js"></script>
<script src="./plugins/datatables-buttons/js/buttons.colVis.min.js"></script>


<style type="text/css">
	#tr_clone{
		display: none;
	}
	td{
		vertical-align: middle;
	}
	td p {
		margin: unset;
	}
	td input[type='number']{
		height: calc(100%);
		width: calc(100%);

	}
	input[type=number]::-webkit-inner-spin-button, 
	input[type=number]::-webkit-outer-spin-button { 
	  -webkit-appearance: none; 
	  margin: 0; 
	}
</style>

<script>
$(document).ready(function() {
    // Click event handler for the SKU column
    $('#load_table').on('click', 'td.clickable-sku', function(e) {
        e.preventDefault();
        var productId = $(this).data('product-id');
        
        // AJAX call to fetch product details
        $.ajax({
            url: 'fetch_product_details.php',
            type: 'POST',
            data: { id: productId },
            dataType: 'json',
            success: function(response) {
                // Populate modal fields with product details
                $('#sku').val(response.sku);
                $('#category').val(response.category_name);
                $('#p_name').val(response.name);
                $('#cost_price').val(response.cost_price);
                $('#price').val(response.price);
                $('#price2').val(response.price2);
                $('#price3').val(response.price3);
                
                // Show the modal
                $('#view_product').modal('show');
            },
            error: function(xhr, status, error) {
                console.error("Error fetching product details:", error);
            }
        });
    });
});
</script>

<script>
    
  $(function () {
    $("#load_table").DataTable({
      "responsive": true, "lengthChange": true, "autoWidth": false, "info": true,"ordering": true, "paging": true, "searching": true,
      "buttons": ["copy", "csv", "excel", "pdf", "print", "colvis"]
    }).buttons().container().appendTo('#load_table_wrapper .col-md-6:eq(0)');
   
  });
</script>

<script>
	$('.select2').select2({
      placeholder:"Select Store",
      width:"100%"
    });
</script>