<?php $year = date('Y'); ?>
<br/>
  <div class="col-lg-12">
    <div class="card card-outline card-warning">
            <div class="card-header">
                <h2 class="card-title"><b><?php echo "Welcome back ".$_SESSION['login_names']."!"  ?></b></h2>

                <div class="card-tools">
                <button type="button" class="btn btn-tool" data-card-widget="collapse">
                    <i class="fas fa-minus"></i>
                </button>
                <button type="button" class="btn btn-tool" data-card-widget="remove">
                    <i class="fas fa-times"></i>
                </button>
                </div>
            </div>


            <!-- Start from here .... -->
            <div class="card-body">
              <div class="row">
               
              <div class="col-md-4">
                <!-- Widget: user widget style 1 -->
                <div class="card card-widget widget-user">
                <!-- Add the bg color to the header using any of the bg-* card-outline card-warning classes  -->
                <?php $todate = date('d-M-Y'); ?>
                <div class="widget-user-header bg-info ">
                  <h3 class="widget-user-username">Today's Sales</h3>
                  <h5 class="widget-user-desc"><?php echo $todate ?></h5>
                </div>
                <div class="widget-user-image">
                  <img class="img-circle elevation-2" src="./images/pos.jpg" alt="User Avatar">
                </div>
                
                <div class="card-footer">
                  <div class="row">
                  <div class="col-sm-4 border-right">
                    <div class="description-block">
                    <h5 class="description-header"><?php 
                      include('./private/db_connect.php');
                      $sales = $conn->query("SELECT SUM(total_amount) as amount FROM sales_list WHERE date(date_updated)= '".date('Y-m-d')."' AND mpay_id= '1' AND store_id = '".$_SESSION['login_store_id']."'");
                      echo $sales->num_rows > 0 ? "&#8358; ".number_format($sales->fetch_array()['amount'],2) : "0.00"; 
                      ?></h5>
                    <span class="description-text">CASH</span>
                    </div>
                    <!-- /.description-block </?php echo "&#8358; ".number_format(54673,2) ?> -->
                  </div>
                  <!-- /.col -->
                  <div class="col-sm-4 border-right">
                    <div class="description-block">
                    <h5 class="description-header"><?php 
                      include('./private/db_connect.php');
                      $sales = $conn->query("SELECT SUM(total_amount) as amount FROM sales_list WHERE date(date_updated)= '".date('Y-m-d')."' AND mpay_id= '2' AND store_id = '".$_SESSION['login_store_id']."'");
                      echo $sales->num_rows > 0 ? "&#8358; ".number_format($sales->fetch_array()['amount'],2) : "0.00"; 
                      ?></h5>
                    <span class="description-text">POS</span>
                    </div>
                    <!-- /.description-block -->
                  </div>
                  <!-- /.col -->
                  <div class="col-sm-4">
                    <div class="description-block">
                    <h5 class="description-header"><?php 
                      include('./private/db_connect.php');
                      $sales = $conn->query("SELECT SUM(total_amount) as amount FROM sales_list WHERE date(date_updated)= '".date('Y-m-d')."' AND mpay_id= '3' AND store_id = '".$_SESSION['login_store_id']."'");
                      echo $sales->num_rows > 0 ? "&#8358; ".number_format($sales->fetch_array()['amount'],2) : "0.00"; 
                      ?></h5>
                    <span class="description-text">TRANSFER</span>
                    </div>
                    <!-- /.description-block -->
                  </div>
                  
                  </div>
                </div>
                <a href="./index.php?page=daily_sales_summary" class="small-box-footer">
                    More info <i class="fas fa-arrow-circle-right"></i>
                  </a>
                </div>
              </div>

            
		
		
                
            <!-- Daily Sales Display  -->
          <div class="col-md-8">
            <div class="card card-outline card-info">
              <div class="card-header">
                <h2 class="card-title"><b>Today's Total Sales</b></h2>

                <div class="card-tools">
                  <button type="button" class="btn btn-tool" data-card-widget="collapse">
                  <i class="fas fa-minus"></i>
                  </button>
                  <button type="button" class="btn btn-tool" data-card-widget="remove">
                  <i class="fas fa-times"></i>
                  </button>
                </div>
              </div>
              <div class="card-body">
                <table id="salestable" class="table table-bordered table-striped">
                <!-- <table class="table table-bordered table-striped" id="load_table"> -->
                <thead>
                  <th class="text-left">Invoice No</th>
                  <th class="text-left">Date</th>
                  <th class="text-left">Actioned By</th>
                  <th class="text-left">Mode</th>
                  <th class="text-right">Total Amount</th>
                </thead>
                <tbody>
                  <?php
                    $cum_sales = 0;

                    // Fetch payment modes
                    $mpay = $conn->query("SELECT * FROM pay_mode order by mode_name asc");
                    while ($row = $mpay->fetch_assoc()) {
                        $str_arr[$row['mpay_id']] = $row['mode_name'];
                    }

                    // Fetch sales information including user details
                    $sales = $conn->query("SELECT s.*, u.names FROM sales_list s
                        JOIN users u ON s.user_id = u.id
                        WHERE date(s.date_updated) = '" . date('Y-m-d') . "'
                        AND s.store_id = '". $_SESSION['login_store_id'] ."'
                        ORDER BY date(s.date_updated) DESC");

                    while ($row = $sales->fetch_assoc()) {
                        $cum_sales += $row['total_amount'];
                  ?>
                      <tr>
                          <td class="">
                              <a href="#pay_modal" data-toggle="modal"><?php echo $row['ref_no'] ?></a>
                          </td>
                          <td class=""><?php echo $row['date_updated'] ?></td>
                          <td class=""><?php echo $row['names'] ?></td>
                          <td class=""><?php echo isset($str_arr[$row['mpay_id']]) ? $str_arr[$row['mpay_id']] : 'N/A' ?></td>
                          <td class="text-right"><?php echo "&#8358; " . number_format($row['total_amount'], 2) ?></td>
                      </tr>
                  <?php } ?>
                </tbody>
                <tfoot>
                <tr>
                  <td class="text-right" colspan="4"><b>Cumulative Total</b></td>
                  <td class="text-right"><b><?php echo "&#8358; ".number_format($cum_sales,2) ?></b></td>
                </tr>
                </tfoot>
                </table>
              </div>
            </div>
          </div>

              </div>
            
            </div>
            </div>
        </div>
		
		
		<!-- Display Stock Value -->
		<div class="row">
		<div class="col-md-12">
            <div class="card card-outline card-warning">
              <div class="card-header">
              <?php $todate = date('d-M-Y');?>
                  <h2 class="card-title"><b>Stock Value as at <?php echo $todate ?> | By Store</b></h2>

                  <div class="card-tools">
                    <button type="button" class="btn btn-tool" data-card-widget="collapse">
                      <i class="fas fa-minus"></i>
                    </button>
                    <button type="button" class="btn btn-tool" data-card-widget="remove">
                      <i class="fas fa-times"></i>
                    </button>
                  </div>
              </div>
              <div class="card-body">
              <form action="" method="post">
                <div class="row">
                <?php if($_SESSION['login_type'] == 1 OR $_SESSION['login_type'] == 11): ?>
                  <div class="form-group col-md-5">
                  <label class="control-label">Store</label>
                  <select name="stock_store" id="" class="custom-select browser-default select2 form-control-xsm" data-placeholder="Select a Store">
                  <option value=""></option>
                  <?php 
                    $store = $conn->query("SELECT * FROM stores order by store_name asc");
                    while($row=$store->fetch_assoc()):
                  ?>
                    <option value="<?php echo $row['id'] ?>"><?php echo $row['store_name'] ?></option>
                  <?php endwhile; ?>
                  </select>
                  </div>
                <?php endif; ?>
                <?php if($_SESSION['login_type'] == 2 OR $_SESSION['login_type'] == 4): ?>
                  <div class="form-group col-md-5">
                  <label class="control-label">Store</label>
                  <select name="stock_store" id="" class="custom-select browser-default select2 form-control-xsm" data-placeholder="Select a Store">
                  <option value=""></option>
                  <?php 
                    $store = $conn->query("SELECT * FROM stores WHERE id = '".$_SESSION['login_store_id']."' order by store_name asc");
                    while($row=$store->fetch_assoc()):
                  ?>
                    <option value="<?php echo $row['id'] ?>"><?php echo $row['store_name'] ?></option>
                  <?php endwhile; ?>
                  </select>
                  </div>
                <?php endif; ?>

                  <div class="col-md-4">
                  <div class="form-group">
                  <label for="" class="control-label" style="color: white"> Search  </label>
                    <button name="stock" class="btn btn-block btn-warning btn-sm">Search</button>
                  </div>
                  </div>

                </div>  
              </form>
				<table id="stockvalue" class="table table-bordered table-striped" style="font-size: 12px;">
				  <thead>
					<th class="text-center">#</th>
					<th class="text-left">SKU</th>
					<th class="text-left">Product Name</th>
					<th class="text-center">Cost Price</th>
					<th class="text-center">Selling Price</th>
					<th class="text-center">Qty</th>
					<th class="text-center">Total Amount</th>
				  </thead>
				  <tbody>
					<?php 
					$ava_stock = 0;
					$cum_qty = 0;
					$cum_amount = 0;
					$total_price = 0;
						
					  if (isset($_POST['stock_store']) && isset($_POST['stock'])) {
						$branch = $_POST['stock_store'];
						$i = 1;
						
						$product = $conn->query("SELECT * FROM product_list WHERE `store_id` = '$branch' AND product_status = 1 ORDER BY name ASC");
						
						while ($row_p = $product->fetch_assoc()) {
						  $name = $row_p['name'];
						  $sku = $row_p['sku'];
						  $selling_price = $row_p['price'];
						  $cost_price = $row_p['cost_price'];

						  $sinv = $conn->query("SELECT * FROM main_store WHERE `store_id` = '$branch' AND product_id = ".$row_p['id']);
						  
						  while ($row_i = $sinv->fetch_assoc()) {
							$sin = $row_i['total_stock'];
							$sout = $row_i['total_sales'];
							$ava_stock = $row_i['total_bal'];
						  }
						  
						  $total_price = ($selling_price * $ava_stock);
						  $cum_qty += $ava_stock;
						  $cum_amount += $total_price;
					?>
						  <tr>
							<td class="text-center"><?php echo $i++ ?></td>
							<td class=""><?php echo $sku; ?></td>
							<td class=""><?php echo $name; ?></td>
							<td class="text-right"><?php echo "&#8358; " . number_format($cost_price, 2) ?></td>
							<td class="text-right"><?php echo "&#8358; " . number_format($selling_price, 2) ?></td>
							<td class="text-right"><?php echo number_format($ava_stock) ?></td>
							<td class="text-right"><?php echo "&#8358; " . number_format($total_price, 2) ?></td>
						  </tr>
					<?php 
						}
					  }
					?>
				  </tbody>
				  <tfoot>
					<tr>
					  <td class="text-right" colspan="5">Cumulative Total</td>
					  <td class="text-right"><?php echo number_format($cum_qty, 1) ?></td>
					  <td class="text-right"><?php echo "&#8358; " . number_format($cum_amount, 2) ?></td>
					</tr>
				  </tfoot>
				</table>

              </div>
            </div>
		</div>
		</div>
		
		

        <!-- Daily Sales By Cashier  -->
        <div class="row">
        <div class="col-md-12">
        <div class="card card-outline card-success">
          <div class="card-header">
            <h2 class="card-title"><b>Daily Sales By Cashier</b></h2>

            <div class="card-tools">
            <button type="button" class="btn btn-tool" data-card-widget="collapse">
              <i class="fas fa-minus"></i>
            </button>
            <button type="button" class="btn btn-tool" data-card-widget="remove">
              <i class="fas fa-times"></i>
            </button>
            </div>
          </div>
            <div class="card-body">

            <div class="row">
            <div class="col-md-12">
            <form class="form-inline" method="POST" action="">
            <!-- <form class="form-inline" id ="searchForm"> -->
              <div class="row">
              <?php if($_SESSION['login_type'] == 1 OR $_SESSION['login_type'] == 11): ?>
                  <div class="col-md-4">
                    <div class="form-group">
                        <label class="control-label">Store:</label>
                        <select name="store_id" id="" class="form-control form-control-sm select2" data-placeholder="Select a Store" style="width: 100%;">
                            <option value=""></option>
                        <?php 
                            $stores = $conn->query("SELECT * FROM stores order by store_name asc");
                            while($row=$stores->fetch_assoc()):
                        ?>
                            <option value="<?php echo $row['id'] ?>"><?php echo $row['store_name'] ?></option>
                        <?php endwhile; ?>
                        </select>
                        </div>
                    </div>
              <?php endif; ?>
              <?php if($_SESSION['login_type'] == 2 OR $_SESSION['login_type'] == 4): ?>
                  <div class="col-md-4">
                    <div class="form-group">
                        <label class="control-label">Store:</label>
                        <select name="store_id" id="" class="form-control form-control-sm select2" data-placeholder="Select a Store" style="width: 100%;">
                            <option value=""></option>
                        <?php 
                            $stores = $conn->query("SELECT * FROM stores WHERE id = '".$_SESSION['login_store_id']."' ORDER BY store_name asc");
                            while($row=$stores->fetch_assoc()):
                        ?>
                            <option value="<?php echo $row['id'] ?>"><?php echo $row['store_name'] ?></option>
                        <?php endwhile; ?>
                        </select>
                        </div>
                    </div>
              <?php endif; ?>

                <div class="col-md-3">
                  <div class="form-group">
                    <label for="" class="control-label">Date : </label>
                    <div class="input-group date" id="reservationdate" data-target-input="nearest">
                        <input type="text" name="date1" value="<?php echo isset($_POST['date1']) ? $_POST['date1'] : '' ?>" class="form-control form-control-sm datetimepicker-input" autocomplete="off" data-target="#reservationdate"/>
                        <div class="input-group-append" data-target="#reservationdate" data-toggle="datetimepicker">
                            <div class="input-group-text"><i class="fa fa-calendar"></i></div>
                        </div>
                    </div>
                  </div>
                </div>
                <div class="col-md-3">
                  <div class="form-group">
                    <label for="" class="control-label">To : </label>
                    <div class="input-group date" id="reservationdate1" data-target-input="nearest">
                        <input type="text" name="date2" value="<?php echo isset($_POST['date2']) ? $_POST['date2'] : '' ?>" class="form-control form-control-sm datetimepicker-input" autocomplete="off" data-target="#reservationdate1"/>
                        <div class="input-group-append" data-target="#reservationdate1" data-toggle="datetimepicker">
                            <div class="input-group-text"><i class="fa fa-calendar"></i></div>
                        </div>
                    </div>
                  </div>
                </div>
              
                <div class="col-sm-2">
                  <div class="form-group">
                    <label class="control-label">&nbsp</label>
                    <button name="search" class="btn btn-block btn-info btn-sm"><i class="fa fa-search"></i> Search</button>
                    <!-- <button type="button" id ="search" name="search" class="btn btn-block btn-info btn-sm"><i class="fa fa-search"></i> Search</button> -->
                  </div>
                </div>
              </div>
            </form>
            <br /><br />
            <table class="table table-bordered table-striped" id="load_table">
            <thead>
                <th class="text-center">#</th>
                <th class="text-left">Date</th>
                <th class="text-left">Store</th>
                <th class="text-left">Cashier Name</th>
                <th class="text-right">Cash</th>
                <th class="text-right">POS</th>
                <th class="text-right">Transfer</th>
                <!-- <th class="text-right">Total Amount</th> -->
            </thead>
            <tbody>  
                <?php
                // Retrieve POST data
                $i = 1;
                $cum_sales = array(); // Array to store cumulative sales for each user_id

                if (isset($_POST['search'])) {
                    $date = date("Y-m-d", strtotime($_POST['date1']));
                    $date2 = date("Y-m-d", strtotime($_POST['date2']));
                    $storeId = $_POST['store_id'];

                    $sql = mysqli_query($conn, "SELECT
                        CAST(`s`.`date_updated` AS DATE) AS `date_updated`,
                        `s`.`mpay_id` AS `mpay_id`,
                        `b`.`id` AS `store_id`,
                        `u`.`id` AS `user_id`,
                        `b`.`store_name` AS `store_name`,
                        `u`.`names` AS `cashier`,
                        SUM(CASE WHEN `s`.`mpay_id` = '1' THEN `s`.`total_amount` ELSE 0 END) AS `cash`,
                        SUM(CASE WHEN `s`.`mpay_id` = '2' THEN `s`.`total_amount` ELSE 0 END) AS `pos`,
                        SUM(CASE WHEN `s`.`mpay_id` = '3' THEN `s`.`total_amount` ELSE 0 END) AS `transfer`,
                        SUM(CASE WHEN `s`.`mpay_id` = '0' THEN `s`.`total_amount` ELSE 0 END) AS `others`
                        FROM `martvet_db`.`sales_list` `s` 
                        JOIN `martvet_db`.`stores` `b` ON `b`.`id` = `s`.`store_id`
                        JOIN `martvet_db`.`users` `u` ON `u`.`id` = `s`.`user_id`
                        WHERE `s`.`store_id` = '$storeId' AND DATE(`s`.`date_updated`) BETWEEN '$date' AND '$date2'
                        GROUP BY `u`.`id`");

                    if ($sql) {
                        while ($fetch = mysqli_fetch_array($sql)) {
                            $total_sales = $fetch['cash'] + $fetch['pos'] + $fetch['transfer'] + $fetch['others'];
                            $cum_sales[$fetch['user_id']] = isset($cum_sales[$fetch['user_id']]) ? $cum_sales[$fetch['user_id']] + $total_sales : $total_sales;
                            ?>
                            <tr>
                                <td class="text-center"><?php echo $i++ ?></td> 
                                <td><?php echo date("d-m-Y", strtotime($fetch['date_updated'])); ?></td>
                                <td class="text-left"><?php echo ($fetch['store_name']) ?></td>
                                <td class="text-left"><?php echo ($fetch['cashier']) ?></td>
                                <td class="text-right"><?php echo "&#8358; " . number_format($fetch['cash'], 2) ?></td>
                                <td class="text-right"><?php echo "&#8358; " . number_format($fetch['pos'], 2) ?></td>
                                <td class="text-right"><?php echo "&#8358; " . number_format($fetch['transfer'], 2) ?></td> 
                                <!-- <td class="text-right"></?php echo "&#8358; " . number_format($total_sales, 2) ?></td> -->
                            </tr>
                            <?php
                        }
                    }
                }
                ?>
                </tbody>
                <tfoot>
                <?php
                  foreach ($cum_sales as $user_id => $cumulative_total) {
                      $cashier_name = ''; // Initialize cashier name
                      // Query the database to get the cashier name based on user_id
                      $user_query = mysqli_query($conn, "SELECT `names` FROM `martvet_db`.`users` WHERE `id` = '$user_id'");
                      if ($user_query && mysqli_num_rows($user_query) > 0) {
                          $user_data = mysqli_fetch_assoc($user_query);
                          $cashier_name = $user_data['names'];
                      }
                      ?>
                      <tr>
                          <td colspan="6" class="text-right"><b><?php echo $cashier_name ?></b></td>
                          <td class="text-right"><b><?php echo "&#8358; " . number_format($cumulative_total, 2) ?></b></td>
                      </tr>
                      <?php
                  }
                ?>

                </tfoot>
            </table>
            </div>
            </div>
        </div>
      </div>
      </div>
      </div>

        
        <!-- Sales Last 30 Days Graph
        <div class="row">
          <div class="col-md-12">
              <div class="card bg-gradient-info">
              <div class="card-header border-0">
                <h3 class="card-title">
                  <i class="fas fa-th mr-1"></i>
                  Sales Last 30 Days Graph
                </h3>

                  <div class="card-tools">
                    <button type="button" class="btn btn-tool" data-card-widget="collapse">
                      <i class="fas fa-minus"></i>
                    </button>
                    <button type="button" class="btn btn-tool" data-card-widget="remove">
                      <i class="fas fa-times"></i>
                    </button>
                  </div>
              </div>
              <div class="card-body">
                <div class="chart">
                </div>
                 <canvas class="chart" id="line-chart" style="min-height: 250px; height: 250px; max-height: 250px; max-width: 100%;"></canvas>
              </div>
            </div>
          </div>
        </div> -->


         <!-- Sales Current Financial Year Graph 
        <div class="row">
          <div class="col-md-12">
            <div class="card card-outline card-info">
              <div class="card-header">
                <h2 class="card-title">
                  <i class="fas fa-th mr-1"></i>
                  Financial Year Sales Between  <?php echo $year-1; ?> and <?php echo $year; ?>
                </h2>
                  <div class="card-tools">
                    <button type="button" class="btn btn-tool" data-card-widget="collapse">
                      <i class="fas fa-minus"></i>
                    </button>
                    <button type="button" class="btn btn-tool" data-card-widget="remove">
                      <i class="fas fa-times"></i>
                    </button>
                  </div>
              </div>
              <div class="card-body">
                <div class="chart">
                    <canvas id="lineChart" style="height:250px"></canvas>
                </div>
              </div>
                
            </div>
          </div>
        </div>-->

        

     <!-- Product Reorder Level -->
        <div class ="row">
            <div class="col-md-12">
                <div class="card card-outline card-warning">
                    <div class="card-header">
                        <h2 class="card-title"><b>Product Reorder Alert</b></h2>

                        <div class="card-tools">
                            <button type="button" class="btn btn-tool" data-card-widget="collapse">
                            <i class="fas fa-minus"></i>
                            </button>
                            <button type="button" class="btn btn-tool" data-card-widget="remove">
                            <i class="fas fa-times"></i>
                            </button>
                        </div>
                    </div>
                    <div class="card-body">
                    <table id="example3" class="table table-bordered table-striped"> 
                <thead>
                  <th class="text-center">#</th>
                  <th class="text-left">Product Name</th>
                  <th class="text-center">Total Stock</th>
                  <th class="text-center">Ava Stock</th>
                  <th class="text-center">Reorder</th>
                </thead>
                  <tbody>
                  <?php 

                    $total_av = 0;
                    $reorder = 0;
                    
                    $i = 1;
                    $inv_query = $conn->query("SELECT * FROM `inventory` WHERE `type` ='1' AND `store_id` = '".$_SESSION['login_store_id']."' GROUP BY product_id");
                    while($row=$inv_query->fetch_assoc()):
                        $reorder = $row['reorder'];

                    $product = $conn->query("SELECT * FROM product_list WHERE `id`='".$row['product_id']."' ORDER BY name ASC");
                    $name = "";
                    while($row_p=$product->fetch_assoc())
                    {
                      $name = $row_p['name'];
                    }
                    $sinv = $conn->query("SELECT * FROM main_store WHERE `store_id` = '".$_SESSION['login_store_id']."' AND product_id = ".$row['product_id']);
                    while($row_i=$sinv->fetch_assoc())
                    {
                      $totstock = $row_i['total_stock'];
                      $total_av = $row_i['total_bal'];
                    }
                    
                  ?>
                    <tr>
                        <td class="text-center"><?php echo $i++ ?></td>
                        <td class=""><?php echo $name; ?></td>
                        <td class="text-right"><?php echo number_format($totstock, 1) ?></td>
                        <td class="text-right"><?php echo number_format($total_av, 1) ?></td>
                        <td class="text-right"><?php echo number_format($reorder) ?></td>
                        
                      </tr>
                    <?php endwhile; ?>
                  </tbody>
                </table>
                    </div>
                    
                </div>
            </div>
        </div>
        
        <!-- List of Expiring Product -->
        <div class="row">
            <div class="col-md-12">
                <div class="card card-outline card-danger">
                    <div class="card-header">
                    <h2 class="card-title"><b>List of Expiring Items within 90 Days</b></h2>

                    <div class="card-tools">
                        <button type="button" class="btn btn-tool" data-card-widget="collapse">
                        <i class="fas fa-minus"></i>
                        </button>
                        <button type="button" class="btn btn-tool" data-card-widget="remove">
                        <i class="fas fa-times"></i>
                        </button>
                    </div>
                    </div>
                    <div class="card-body">

                    <?php
                        // Calculate the date three months from now
                        $threeMonthsFromNow = date('m/d/Y', strtotime('+3 months'));

                        $query = "
                            SELECT
                                pl.id,
                                pl.name,
                                IFNULL(SUM(CASE WHEN i.type = 1 THEN i.qty ELSE 0 END) - SUM(CASE WHEN i.type = 2 THEN i.qty ELSE 0 END), 0) AS ava_qty,
                                i.expire_date
                            FROM
                                product_list pl
                            LEFT JOIN
                                inventory i ON pl.id = i.product_id
                            WHERE
                                i.expire_date <= '$threeMonthsFromNow' AND i.expire_date >= CURDATE() AND i.store_id = '". $_SESSION['login_store_id'] ."'
                            GROUP BY
                                pl.id, pl.name, i.expire_date
                            HAVING
                                ava_qty > 0
                        ";

                        $result = mysqli_query($conn, $query);

                        $i = 1;

                        ?>

                        <table id="example4" class="table table-bordered table-striped">
                            <thead>
                                <th class="text-center">#</th>
                                <th class="text-left">Product Name</th>
                                <th class="text-center">Ava Qty</th>
                                <th class="text-center">Expire Date</th>
                            </thead>
                            <tbody>
                                <?php while ($row = mysqli_fetch_assoc($result)) { ?>
                                    <tr>
                                        <td class="text-center"><?php echo $i++; ?></td>
                                        <td class="text-left"><?php echo $row['name']; ?></td>
                                        <td class="text-right"><?php echo $row['ava_qty']; ?></td>
                                        <td class="text-right"><?php echo date('m/d/Y', strtotime($row['expire_date'])); ?></td>
                                    </tr>
                                <?php } ?>
                            </tbody>
                        </table>

                    </div>
                    
                </div>
            </div>
        </div>
       
       
          <!-- Display Daily Sales By Product -->
        <div class="row">
          <div class="col-md-12">
            <div class="card card-outline card-primary">
              <div class="card-header">
                  <h2 class="card-title"><b>Today's Sales By Product</b></h2>

                  <div class="card-tools">
                    <button type="button" class="btn btn-tool" data-card-widget="collapse">
                      <i class="fas fa-minus"></i>
                    </button>
                    <button type="button" class="btn btn-tool" data-card-widget="remove">
                      <i class="fas fa-times"></i>
                    </button>
                  </div>
              </div>
              <div class="card-body">
                <table id="example7" class="table table-bordered table-striped"> 
                <!-- <table class="table table-bordered table-hover" id="load_table">-->
                <thead>
                  <th class="text-center">#</th>
                  <th class="text-left">Product Name</th>
                  <th class="text-center">Price</th>
                  <th class="text-center">Qty</th>
                  <th class="text-center">Total Amount</th>
                </thead>
                  <tbody>
                  <?php 

                    $total_sales=0;
                    $cum_sales = 0;
                    $cum_qty = 0;

                    $i = 1;
                    $stock_out_query = $conn->query("SELECT * FROM `inventory` WHERE `type` ='2'  GROUP BY product_id");
                    while($row=$stock_out_query->fetch_assoc()):

                    $product = $conn->query("SELECT * FROM product_list WHERE `id`='".$row['product_id']."' ORDER BY name ASC");
                    $name = "";
                    while($row_p=$product->fetch_assoc())
                    {
                      $name = $row_p['name'];
                      $selling_price = $row_p['price'];
                    }
                    // DATE(`date_updated`) BETWEEN ".date('Y-m-d')." AND ".date('Y-m-d')." AND
                    $sout = $conn->query("SELECT sum(qty) as `sout` FROM inventory WHERE date(date_updated)= '".date('Y-m-d')."' AND `store_id` = '". $_SESSION['login_store_id'] ."' AND `type` = 2 AND product_id = ".$row['product_id']);
                    $sout = $sout && $sout->num_rows > 0 ? $sout->fetch_array()['sout'] : 0;
                    $sp = $conn->query("SELECT sprice as `sp` FROM inventory WHERE date(date_updated)= '".date('Y-m-d')."' AND `store_id` = '". $_SESSION['login_store_id'] ."' AND `type` = 2 AND product_id = ".$row['product_id']);
                    $sp = $sp && $sp->num_rows > 0 ? $sp->fetch_array()['sp'] : 0;
                    $tsp = $sout * $sp;
                    $total_sales += $tsp; 
                    
                    $cum_qty += $sout;
                    $cum_sales += $total_sales;

                  ?>
                    <tr>
                        <td class="text-center"><?php echo $i++ ?></td>
                        <td class=""><?php echo $name; ?></td>
                        <td class="text-right"><?php echo "&#8358; ".number_format($sp, 2) ?></td>
                        <td class="text-right"><?php echo number_format($sout) ?></td>
                        <td class="text-right"><?php echo "&#8358; ".number_format($tsp, 2) ?></td>
                        
                      </tr>
                    <?php endwhile; ?>
                  </tbody>
                  <tfoot>
                  <tr>
                    <td class="text-right" colspan="3">Cumulative Total</td>
                    <td class="text-right"><?php echo number_format($cum_qty,2) ?></td>
                    <td class="text-right"><?php echo "&#8358; ".number_format($cum_sales,2) ?></td>
                  </tr>
                </tfoot>
                </table>
              </div>
            </div>
	  </div>
  </div>
		        
        <?php include('./private/graph.php'); ?>

 <!-- DataTables  & Plugins -->
 <script src="./plugins/datatables/jquery.dataTables.min.js"></script>
<script src="./plugins/datatables-bs4/js/dataTables.bootstrap4.min.js"></script>
<script src="./plugins/datatables-responsive/js/dataTables.responsive.min.js"></script>
<script src="./plugins/datatables-responsive/js/responsive.bootstrap4.min.js"></script>
<script src="./plugins/datatables-buttons/js/dataTables.buttons.min.js"></script>
<script src="./plugins/datatables-buttons/js/buttons.bootstrap4.min.js"></script>
<script src="./plugins/jszip/jszip.min.js"></script>
<script src="./plugins/pdfmake/pdfmake.min.js"></script>
<script src="./plugins/pdfmake/vfs_fonts.js"></script>
<script src="./plugins/datatables-buttons/js/buttons.html5.min.js"></script>
<script src="./plugins/datatables-buttons/js/buttons.print.min.js"></script>
<script src="./plugins/datatables-buttons/js/buttons.colVis.min.js"></script>

<script>
 $(function () {
  $('#salestable').DataTable({
      "paging": true,
      "lengthChange": false,
      "searching": true,
      "ordering": true,
      "info": true,
      "autoWidth": false,
      "responsive": true,
    });
  
    //  Display Daly Opening Stock
    $('#open_stock').click(function(){
      
      location.href = "index.php?page=openstock"
      
    })
  });
</script>

<script>
  $(function () {
    $("#load_table").DataTable({
      "responsive": true, "lengthChange": false, "autoWidth": false,
      "buttons": ["copy", "csv", "excel", "pdf", "print", "colvis"]
    }).buttons().container().appendTo('#load_table_wrapper .col-md-6:eq(0)');
    $('#example2').DataTable({
      "paging": true,
      "lengthChange": false,
      "searching": true,
      "ordering": true,
      "info": true,
      "autoWidth": false,
      "responsive": true,
    });

    $('#example1').DataTable({
      "paging": true,
      "lengthChange": false,
      "searching": true,
      "ordering": true,
      "info": true,
      "autoWidth": false,
      "responsive": true,
    });
	
	$('#stockvalue').DataTable({
      "paging": true,
      "lengthChange": false,
      "searching": true,
      "ordering": true,
      "info": true,
      "autoWidth": false,
      "responsive": true,
    });
  });

//Date picker
    $('#reservationdate').datetimepicker({
        format: 'MM/DD/YYYY'
    });

	$('#reservationdate1').datetimepicker({
		format: 'MM/DD/YYYY'
        // format: 'L'
    });

</script>