<?php
  include('./private/db_connect.php'); // Connect to the database

  // Get low stock products
  $store_id = $_SESSION['login_store_id']; // Store ID from session
  $sql = "SELECT pl.sku, pl.name, ms.total_bal
          FROM product_list pl
          JOIN main_store ms ON pl.id = ms.product_id
          WHERE ms.total_bal <= 10 AND ms.store_id = '$store_id'
          ORDER BY ms.total_bal ASC";

  $result = mysqli_query($conn, $sql);
  $lowStockProducts = mysqli_fetch_all($result, MYSQLI_ASSOC);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Low Stock Alert</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
</head>
  <body>

  <!-- Bootstrap Modal -->
  <div class="modal fade" id="lowStockModal" tabindex="-1" aria-labelledby="lowStockModalLabel" aria-hidden="true">
      <div class="modal-dialog">
          <div class="modal-content">
              <div class="modal-header">
                  <h5 class="modal-title text-danger" id="lowStockModalLabel">⚠️ Low Stock Alert</h5>
                  <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
              </div>
              <div class="modal-body">
                  <?php if (!empty($lowStockProducts)): ?>
                      <p>The following products have low stock (≤ 10):</p>
                      <table class="table table-bordered">
                          <thead>
                              <tr>
                                  <th>SKU</th>
                                  <th>Product Name</th>
                                  <th class="text-center">Available Qty</th>
                              </tr>
                          </thead>
                          <tbody>
                              <?php foreach ($lowStockProducts as $product): ?>
                                  <tr>
                                      <td><?= $product['sku'] ?></td>
                                      <td><?= $product['name'] ?></td>
                                      <td class="text-danger text-center"><b><?= $product['total_bal'] ?></b></td>
                                  </tr>
                              <?php endforeach; ?>
                          </tbody>
                      </table>
                  <?php else: ?>
                      <p>No products are low in stock.</p>
                  <?php endif; ?>
              </div>
              <div class="modal-footer">
                  <button type="button" class="btn btn-danger" data-bs-dismiss="modal">OK</button>
              </div>
          </div>
      </div>
  </div>

  <!-- Sound Alert -->
  <audio id="alertSound">
      <source src="./private/alert.wav" type="audio/mpeg">
  </audio>

  <script>
      function playAlert() {
          let audio = document.getElementById("alertSound");
          audio.play();
      }
  </script>

  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

  <script>
      var alertSound = new Audio('./private/alert.wav'); // Ensure this file exists in the correct directory
      var alertTimer;

      function playAlertSound() {
          alertSound.currentTime = 0;  // Reset sound
          alertSound.play();
      }

      function showLowStockModal() {
          $('#lowStockModal').modal('show'); // Show the modal
          playAlertSound();
      }

      function startAlertTimer() {
          alertTimer = setInterval(function() {
              showLowStockModal();
          }, 400000); // 6 minutes (400,000 ms)
      }

      // Event: When modal is opened
      $('#lowStockModal').on('shown.bs.modal', function () {
          playAlertSound();
      });

      // Event: When modal is closed
      $('#lowStockModal').on('hidden.bs.modal', function () {
          alertSound.pause(); // Stop sound
          alertSound.currentTime = 0; // Reset sound
      });

      // Start timer on page load
      $(document).ready(function() {
          showLowStockModal(); // Show modal on page load
          startAlertTimer();  // Start the 5-minute interval
      });
  </script>

  </body>
</html>


<?php $year = date('Y'); ?>

<!-- Start from here .... -->
 <!-- Note that Warehouse is refer as Store 1 -->
  <!-- // Store 2 -->
    <div class="row">
      <div class="col-md-4">
        <div class="card card-widget widget-user">
            <?php $todate = date('d-M-Y'); ?>
          <div class="widget-user-header bg-info">
            <h3 class="widget-user-username"><?php 
              include('./private/db_connect.php');
              $store1 = $conn->query("SELECT store_name FROM stores WHERE id = 2"); 
              if ($store1->num_rows > 0) {
                  $row = $store1->fetch_array();
                  echo $row['store_name'];
              } else {
                  echo "Store not found";
              }
              ?></h3>
            <h5 class="widget-user-desc"><?php echo $todate ?></h5>
          </div>
          <div class="widget-user-image">
            <img class="img-circle elevation-2" src="./images/pos.jpg" alt="User Avatar">
          </div>
            
          <div class="card-footer">
            <div class="row">
              <div class="col-sm-4 border-right">
                <div class="description-block">
                  <h5 class="description-header"><?php 
                    include('./private/db_connect.php');
                    $sales = $conn->query("SELECT SUM(cash) as amount FROM sales_list WHERE date(date_updated)= '".date('Y-m-d')."' AND store_id = 2");
                    echo $sales->num_rows > 0 ? "&#8358; ".number_format($sales->fetch_array()['amount'],2) : "0.00"; 
                    ?></h5>
                  <span class="description-text">CASH</span>
                </div>
              </div>
              <!-- /.col -->
              <div class="col-sm-4 border-right">
                <div class="description-block">
                  <h5 class="description-header"><?php 
                    include('./private/db_connect.php');
                    $sales = $conn->query("SELECT SUM(pos) as amount FROM sales_list WHERE date(date_updated)= '".date('Y-m-d')."' AND  store_id = 2");
                    echo $sales->num_rows > 0 ? "&#8358; ".number_format($sales->fetch_array()['amount'],2) : "0.00"; 
                    ?></h5>
                  <span class="description-text">POS</span>
                </div>
              </div>
              <!-- /.col -->
              <div class="col-sm-4">
                <div class="description-block">
                  <h5 class="description-header"><?php 
                    include('./private/db_connect.php');
                    $sales = $conn->query("SELECT SUM(transfer) as amount FROM sales_list WHERE date(date_updated)= '".date('Y-m-d')."' AND store_id = 2");
                    echo $sales->num_rows > 0 ? "&#8358; ".number_format($sales->fetch_array()['amount'],2) : "0.00"; 
                    ?></h5>
                  <span class="description-text">TRANSFER</span>
                </div>
              </div>
              <div class>
                <h4>Total Sales:
                  <?php 
                    include('./private/db_connect.php');
                    $sales = $conn->query("SELECT SUM(total_amount) as amount FROM sales_list WHERE date(date_updated)= '".date('Y-m-d')."' AND store_id = 2");
                    echo $sales->num_rows > 0 ? "&#8358; ".number_format($sales->fetch_array()['amount'],2) : "0.00"; 
                  ?>
                </h4>
              </div>
            </div>
            <a href="index.php?page=daily_sales_summary" class="small-box-footer d-block text-center">
                More info <i class="fas fa-arrow-circle-right"></i>
            </a>
          </div>
        </div>
      </div>

      <!-- // Store 3 -->
      <div class="col-md-4">
        <div class="card card-widget widget-user">
            <?php $todate = date('d-M-Y'); ?>
          <div class="widget-user-header bg-warning">
            <h3 class="widget-user-username"><?php 
              include('./private/db_connect.php');
              $store1 = $conn->query("SELECT store_name FROM stores WHERE id = 3"); 
              if ($store1->num_rows > 0) {
                  $row = $store1->fetch_array();
                  echo $row['store_name'];
              } else {
                  echo "Store not found";
              }
              ?></h3>
            <h5 class="widget-user-desc"><?php echo $todate ?></h5>
          </div>
          <div class="widget-user-image">
            <img class="img-circle elevation-2" src="./images/pos.jpg" alt="User Avatar">
          </div>
            
          <div class="card-footer">
            <div class="row">
              <div class="col-sm-4 border-right">
                <div class="description-block">
                  <h5 class="description-header"><?php 
                    include('./private/db_connect.php');
                    $sales = $conn->query("SELECT SUM(cash) as amount FROM sales_list WHERE date(date_updated)= '".date('Y-m-d')."' AND store_id = 3");
                    echo $sales->num_rows > 0 ? "&#8358; ".number_format($sales->fetch_array()['amount'],2) : "0.00"; 
                    ?></h5>
                  <span class="description-text">CASH</span>
                </div>
              </div>
              <!-- /.col -->
              <div class="col-sm-4 border-right">
                <div class="description-block">
                  <h5 class="description-header"><?php 
                    include('./private/db_connect.php');
                    $sales = $conn->query("SELECT SUM(pos) as amount FROM sales_list WHERE date(date_updated)= '".date('Y-m-d')."' AND store_id = 3");
                    echo $sales->num_rows > 0 ? "&#8358; ".number_format($sales->fetch_array()['amount'],2) : "0.00"; 
                    ?></h5>
                  <span class="description-text">POS</span>
                </div>
              </div>
              <!-- /.col -->
              <div class="col-sm-4">
                <div class="description-block">
                  <h5 class="description-header"><?php 
                    include('./private/db_connect.php');
                    $sales = $conn->query("SELECT SUM(transfer) as amount FROM sales_list WHERE date(date_updated)= '".date('Y-m-d')."' AND store_id = 3");
                    echo $sales->num_rows > 0 ? "&#8358; ".number_format($sales->fetch_array()['amount'],2) : "0.00"; 
                    ?></h5>
                  <span class="description-text">TRANSFER</span>
                </div>
              </div>
              <div class>
                <h4>Total Sales:
                  <?php 
                    include('./private/db_connect.php');
                    $sales = $conn->query("SELECT SUM(total_amount) as amount FROM sales_list WHERE date(date_updated)= '".date('Y-m-d')."' AND store_id = 3");
                    echo $sales->num_rows > 0 ? "&#8358; ".number_format($sales->fetch_array()['amount'],2) : "0.00"; 
                  ?>
                </h4>
              </div>
            </div>
            <a href="index.php?page=daily_sales_summary" class="small-box-footer d-block text-center">
                More info <i class="fas fa-arrow-circle-right"></i>
            </a>
          </div>
        </div>
      </div>

        <!-- // Store 4 -->
          <div class="col-md-4">
            <div class="card card-widget widget-user">
              <?php $todate = date('d-M-Y'); ?>
              <div class="widget-user-header bg-primary">
                <h3 class="widget-user-username"><?php 
                include('./private/db_connect.php');
                $store1 = $conn->query("SELECT store_name FROM stores WHERE id = 4"); 
                if ($store1->num_rows > 0) {
                    $row = $store1->fetch_array();
                    echo $row['store_name'];
                } else {
                    echo "Store not found";
                }
                ?></h3>
                <h5 class="widget-user-desc"><?php echo $todate ?></h5>
              </div>
              
              <div class="widget-user-image">
                <img class="img-circle elevation-2" src="./images/pos.jpg" alt="User Avatar">
              </div>
					
              <div class="card-footer">
                <div class="row">
                  <div class="col-sm-4 border-right">
                    <div class="description-block">
                      <h5 class="description-header"><?php 
                        include('./private/db_connect.php');
                        $sales = $conn->query("SELECT SUM(cash) as amount FROM sales_list WHERE date(date_updated)= '".date('Y-m-d')."' AND store_id = 4");
					              echo $sales->num_rows > 0 ? "&#8358; ".number_format($sales->fetch_array()['amount'],2) : "0.00";
                        ?></h5>
                      <span class="description-text">CASH</span>
                    </div>
                  </div>
                  <!-- /.col -->
                  <div class="col-sm-4 border-right">
                    <div class="description-block">
                    <h5 class="description-header"><?php 
                      include('./private/db_connect.php');
                      $sales = $conn->query("SELECT SUM(pos) as amount FROM sales_list WHERE date(date_updated)= '".date('Y-m-d')."' AND store_id = 4");
					            echo $sales->num_rows > 0 ? "&#8358; ".number_format($sales->fetch_array()['amount'],2) : "0.00";
                      ?></h5>
                    <span class="description-text">POS</span>
                    </div>
                    <!-- /.description-block -->
                  </div>
                  <!-- /.col -->
                  <div class="col-sm-4">
                    <div class="description-block">
                    <h5 class="description-header"><?php 
                      include('./private/db_connect.php');
                      $sales = $conn->query("SELECT SUM(transfer) as amount FROM sales_list WHERE date(date_updated)= '".date('Y-m-d')."' AND store_id = 4");
					            echo $sales->num_rows > 0 ? "&#8358; ".number_format($sales->fetch_array()['amount'],2) : "0.00";
                      ?></h5>
                    <span class="description-text">TRANSFER</span>
                    </div>
                  </div>

                  <div class>
                    <h4>Total Sales:
                      <?php 
                        include('./private/db_connect.php');
                        $sales = $conn->query("SELECT SUM(total_amount) as amount FROM sales_list WHERE date(date_updated)= '".date('Y-m-d')."' AND store_id = 4");
                        echo $sales->num_rows > 0 ? "&#8358; ".number_format($sales->fetch_array()['amount'],2) : "0.00"; 
                      ?>
                    </h4>
                  </div>
                </div>
                <a href="index.php?page=daily_sales_summary" class="small-box-footer d-block text-center">
                  More info <i class="fas fa-arrow-circle-right"></i>
              </a>
              </div>
			      </div>
      </div>
    </div> 

    <!-- /// Total Amount sold by each store -->
    <!-- <div class="row">
        <div class="col-lg-4 col-4">
        
        <div class="small-box bg-info">
        <div class="inner">
            <h3><?php 
            include('./private/db_connect.php');
            $sales = $conn->query("SELECT SUM(total_amount) as amount FROM sales_list WHERE date(date_updated)= '".date('Y-m-d')."' AND store_id = 1");
            echo $sales->num_rows > 0 ? "&#8358; ".number_format($sales->fetch_array()['amount'],2) : "0.00"; 

            ?></h3>

            <p><b>Ladycee Empire - NTA Total Sales</b></p>
        </div>
        <div class="icon">
            <i class="fas fa-shopping-cart"></i>
        </div>
        <a href="index.php?page=daily_sales_summary" class="small-box-footer">
            More info <i class="fas fa-arrow-circle-right"></i>
        </a>
        </div>
        </div>

        <div class="col-lg-4 col-4">
        
        <div class="small-box bg-warning">
        <div class="inner">
            <h3><?php 
            include('./private/db_connect.php');
            // $sales = $conn->query("SELECT SUM(total_amount) as amount FROM sales_list WHERE date(date_updated)= '".date('Y-m-d')."' AND store_id = '".$_SESSION['login_store_id']."'");
            $sales = $conn->query("SELECT SUM(total_amount) as amount FROM sales_list WHERE date(date_updated)= '".date('Y-m-d')."'");
            echo $sales->num_rows > 0 ? "&#8358; ".number_format($sales->fetch_array()['amount'],2) : "0.00"; 

            ?></h3>

            <p><b>Today's Total Sales</b></p>
        </div>
        <div class="icon">
            <i class="fas fa-shopping-cart"></i>
        </div>
        <a href="#" class="small-box-footer">
            More info <i class="fas fa-arrow-circle-right"></i>
        </a>
        </div>
        </div>
        <div class="col-lg-4 col-4">
        
        <div class="small-box bg-primary">
        <div class="inner">
            <h3><?php 
            include('./private/db_connect.php');
            $sales = $conn->query("SELECT SUM(total_amount) as amount FROM sales_list WHERE date(date_updated)= '".date('Y-m-d')."' AND store_id = 2");
            echo $sales->num_rows > 0 ? "&#8358; ".number_format($sales->fetch_array()['amount'],2) : "0.00"; 

            ?></h3>

            <p><b>Ladycee Empire - Agip Total Sales</b></p>
        </div>
        <div class="icon">
            <i class="fas fa-shopping-cart"></i>
        </div>
        <a href="index.php?page=daily_sales_summary" class="small-box-footer">
            More info <i class="fas fa-arrow-circle-right"></i>
        </a>
        </div>
        </div>
    </div> -->

	  
	  <!-- Display Stock Value -->
		<div class="row">
		  <div class="col-md-12">
            <div class="card card-outline card-warning">
              <div class="card-header">
              <?php $todate = date('d-M-Y');?>
                
              
              
                  <h2 class="card-title"><b>Stock Value as at <?php echo $todate ?> | By Store</b></h2>

                  <div class="card-tools">
                    <button type="button" class="btn btn-tool" data-card-widget="collapse">
                      <i class="fas fa-minus"></i>
                    </button>
                    <button type="button" class="btn btn-tool" data-card-widget="remove">
                      <i class="fas fa-times"></i>
                    </button>
                  </div>
              </div>
              <div class="card-body">
              <form action="" method="post">
                <div class="row">
                
                  <div class="form-group col-md-5">
                  <label class="control-label">Store</label>
                  <select name="stock_store" id="" class="custom-select browser-default select2 form-control-xsm" data-placeholder="Select a Store">
                  <option value=""></option>
                  <?php 
                    $store = $conn->query("SELECT * FROM stores order by store_name asc");
                    while($row=$store->fetch_assoc()):
                  ?>
                    <option value="<?php echo $row['id'] ?>"><?php echo $row['store_name'] ?></option>
                  <?php endwhile; ?>
                  </select>
                  </div>
                  <div class="col-md-4">
                  <div class="form-group">
                  <label for="" class="control-label" style="color: white"> Search  </label>
                    <button name="stock" class="btn btn-block btn-warning btn-sm">Search</button>
                  </div>
                  </div>

                </div>  
              </form>
				<table id="example1" class="table table-bordered table-striped" style="font-size: 12px;">
				  <thead>
					<th class="text-center">#</th>
					<th class="text-left">SKU</th>
					<th class="text-left">Product Name</th>
					<th class="text-center">Cost Price</th>
					<th class="text-center">Selling Price</th>
					<th class="text-center">Qty</th>
					<th class="text-center">Total Amount</th>
				  </thead>
				  <tbody>
					<?php 
					$ava_stock = 0;
					$cum_qty = 0;
					$cum_amount = 0;
					$total_price = 0;
						
					  if (isset($_POST['stock_store']) && isset($_POST['stock'])) {
						$branch = $_POST['stock_store'];
						$i = 1;
						
						$product = $conn->query("SELECT * FROM product_list WHERE `store_id` = '$branch' AND product_status = 1 ORDER BY name ASC");
						
						while ($row_p = $product->fetch_assoc()) {
						  $name = $row_p['name'];
						  $sku = $row_p['sku'];
						  $selling_price = $row_p['price'];
						  $cost_price = $row_p['cost_price'];

						  $sinv = $conn->query("SELECT * FROM main_store WHERE `store_id` = '$branch' AND product_id = ".$row_p['id']);
						  
						  while ($row_i = $sinv->fetch_assoc()) {
							$sin = $row_i['total_stock'];
							$sout = $row_i['total_sales'];
							$ava_stock = $row_i['total_bal'];
						  }
						  
						  $total_price = ($selling_price * $ava_stock);
						  $cum_qty += $ava_stock;
						  $cum_amount += $total_price;
					?>
						  <tr>
							<td class="text-center"><?php echo $i++ ?></td>
							<td class=""><?php echo $sku; ?></td>
							<td class=""><?php echo $name; ?></td>
							<td class="text-right"><?php echo "&#8358; " . number_format($cost_price, 2) ?></td>
							<td class="text-right"><?php echo "&#8358; " . number_format($selling_price, 2) ?></td>
							<td class="text-right"><?php echo number_format($ava_stock) ?></td>
							<td class="text-right"><?php echo "&#8358; " . number_format($total_price, 2) ?></td>
						  </tr>
					<?php 
						}
					  }
					?>
				  </tbody>
				  <tfoot>
					<tr>
					  <td class="text-right" colspan="5">Cumulative Total</td>
					  <td class="text-right"><?php echo number_format($cum_qty, 1) ?></td>
					  <td class="text-right"><?php echo "&#8358; " . number_format($cum_amount, 2) ?></td>
					</tr>
				  </tfoot>
				</table>

              </div>
            </div>
		</div>
		</div>
        
        <!-- Daily Sales By Supermarket  --> 
        <div class="row">
            <div class="col-md-12">
            <div class="card card-outline card-info">
                <div class="card-header">
                  <h2 class="card-title"><b>Sales Value as at One Week Ago | By Store</b></h2>

                  <div class="card-tools">
                    <button type="button" class="btn btn-tool" data-card-widget="collapse">
                      <i class="fas fa-minus"></i>
                    </button>
                    <button type="button" class="btn btn-tool" data-card-widget="remove">
                      <i class="fas fa-times"></i>
                    </button>
                  </div>
                </div>
                <div class="card-body">
                    <form action="" method="post">
                        <div class="row">
                        <?php 
                        $dsDate = date('m/d/Y');
                        //$dsDate = '11/23/2022';

                        ?>

                        <div class="form-group col-md-5">
                        <label class="control-label">Store</label>
                        <select name="sales_store" id="" class="custom-select browser-default select2 form-control-xsm" data-placeholder="Select a Store" >
                        <option value=""></option>
                        <?php 
                            $store = $conn->query("SELECT * FROM stores order by store_name asc");
                            while($row=$store->fetch_assoc()):
                        ?>
                        <option value="<?php echo $row['id'] ?>"><?php echo $row['store_name'] ?></option>
                        <?php endwhile; ?>
                        </select>
                        </div>
                        <div class="col-md-4">
                        <div class="form-group">
                        <label for="" class="control-label" style="color: white"> Search  </label>
                        <button name="sales" class="btn btn-block btn-info btn-sm">Search</button>
                        </div>
                        </div>

                        </div>  
                    </form>        
                <table id="example2" class="table table-bordered table-striped" style="font-size: 12px;">
                <!-- <table class="table table-bordered table-striped" id="load_table"> -->
                    <thead>
                    <th class="text-left">Invoice No</th>
                    <th class="text-left">Date</th>
                    <th class="text-left">Actioned By</th>
                    <th class="text-center">Pay Mode</th>
                    <th class="text-center">Total Amount</th>
                    </thead>
                    <tbody>
                        <?php 
                            if(isset($_POST['sales_store']) && isset($_POST['sales'])){
                                $branch = $_POST['sales_store'];
                                $cum_sales = 0;
        
                                $mpay = $conn->query("SELECT * FROM pay_mode order by mode_name asc");
                                while ($row = $mpay->fetch_assoc()) {
                                    $str_arr[$row['mpay_id']] = $row['mode_name'];
                                }
        
                                // Define the start and end dates for the one-week range
                                $start_date = date('Y-m-d', strtotime('-1 week'));
                                $end_date = date('Y-m-d');
        
                                // Fetch sales information including user details for the one-week range
                                $sales = $conn->query("SELECT s.*, u.names FROM sales_list s
                                    JOIN users u ON s.user_id = u.id
                                    WHERE date(s.date_updated) BETWEEN '$start_date' AND '$end_date'
                                    AND s.store_id = '$branch'
                                    ORDER BY date(s.date_updated) DESC");
        
                                while ($row = $sales->fetch_assoc()) {
                                    $cum_sales += $row['total_amount'];
                        ?>
                  
                 
                    <tr>
                        <td class="">
                            <a href="#pay_modal" data-toggle="modal"><?php echo $row['ref_no'] ?></a>
                        </td>
                        <td class=""><?php echo $row['date_updated'] ?></td>
                        <td class=""><?php echo $row['names'] ?></td>
                        <td class=""><?php echo isset($str_arr[$row['mpay_id']]) ? $str_arr[$row['mpay_id']] : 'N/A' ?></td>
                        <td class="text-right"><?php echo "&#8358; " . number_format($row['total_amount'], 2) ?></td>
                    </tr>
                  <?php } 
                                       
                    }else{

                      $cum_sales = 0;
                                              
                      $mpay = $conn->query("SELECT * FROM pay_mode order by mode_name asc");
                      while($row=$mpay->fetch_assoc()):
                      $str_arr[$row['mpay_id']] = $row['mode_name'];
                      endwhile;
                      // $sales = $conn->query("SELECT * FROM sales_list WHERE store_id = 2 AND date(date_updated)= '".date('Y-m-d')."' ORDER BY date(date_updated) DESC");
                      $sales = $conn->query("SELECT s.*, u.names FROM sales_list s
                      JOIN users u ON s.user_id = u.id
                      WHERE date(s.date_updated) = '" . date('Y-m-d') . "'
                      AND s.store_id = 2
                      ORDER BY date(s.date_updated) DESC");
                      while($row=$sales->fetch_assoc()):

                      $cum_sales += $row['total_amount'];
                    
                    ?>
                      <tr>
                        <td class="">
                            <a href="#pay_modal" data-toggle="modal"><?php echo $row['ref_no'] ?></a>
                        </td>
                        <td class=""><?php echo $row['date_updated'] ?></td>
                        <td class=""><?php echo $row['names'] ?></td>
                        <td class=""><?php echo isset($str_arr[$row['mpay_id']]) ? $str_arr[$row['mpay_id']] : 'N/A' ?></td>
                        <td class="text-right"><?php echo "&#8358; " . number_format($row['total_amount'], 2) ?></td>
                      </tr>
                    <?php endwhile; }?>
                    
                    </tbody>
                    <tfoot>
                    <tr>
                        <td class="text-right" colspan="4"><b>Cumulative Total</b></td>
                        <td class="text-right"><b><?php echo "&#8358; ".number_format($cum_sales,2) ?></b></td>
                    </tr>
                    </tfoot>
                    </table>
                </div>
            </div>
            </div>
        </div>
        
        <div class="row">
          
        </div>
 
 <!-- DataTables  & Plugins -->
 <script src="./plugins/datatables/jquery.dataTables.min.js"></script>
<script src="./plugins/datatables-bs4/js/dataTables.bootstrap4.min.js"></script>
<script src="./plugins/datatables-responsive/js/dataTables.responsive.min.js"></script>
<script src="./plugins/datatables-responsive/js/responsive.bootstrap4.min.js"></script>
<script src="./plugins/datatables-buttons/js/dataTables.buttons.min.js"></script>
<script src="./plugins/datatables-buttons/js/buttons.bootstrap4.min.js"></script>
<script src="./plugins/jszip/jszip.min.js"></script>
<script src="./plugins/pdfmake/pdfmake.min.js"></script>
<script src="./plugins/pdfmake/vfs_fonts.js"></script>
<script src="./plugins/datatables-buttons/js/buttons.html5.min.js"></script>
<script src="./plugins/datatables-buttons/js/buttons.print.min.js"></script>
<script src="./plugins/datatables-buttons/js/buttons.colVis.min.js"></script>

<script>
 $(function () {
  $('#salestable').DataTable({
      "paging": true,
      "lengthChange": false,
      "searching": true,
      "ordering": true,
      "info": true,
      "autoWidth": false,
      "responsive": true,
    });
  
    //  Display Daly Opening Stock
    $('#open_stock').click(function(){
      
      location.href = "index.php?page=openstock"
      
    })
  });
</script>

<script>
  

//Date picker
    $('#reservationdate').datetimepicker({
        format: 'MM/DD/YYYY'
    });

	$('#reservationdate1').datetimepicker({
		format: 'MM/DD/YYYY'
        // format: 'L'
    });

</script>