<?php include('./private/db_connect.php');?>


<?php

// -- Get the distinct dates from the inventory table
// $sqlTemp1 = "CREATE TEMPORARY TABLE temp_dates AS
// SELECT DISTINCT date_updated
// FROM inventory
// ORDER BY date_updated";

// if ($conn->query($sqlTemp1) === TRUE) {
//   echo '<script>alert("Temp Table 1 created successfully")</script>';
// } else {
//   echo "Error: " . $sql . "<br>" . $conn->error;
//   exit;
// }

// -- Get the distinct store-product combinations
// $sqlTemp2 = "CREATE TEMPORARY TABLE temp_store_product AS
// SELECT i.store_id, i.product_id
// FROM inventory i
// JOIN product_list pl ON i.product_id = pl.id
// JOIN stores s ON i.store_id = s.id
// GROUP BY i.store_id, i.product_id";

// if ($conn->query($sqlTemp2) === TRUE) {
//   echo '<script>alert("Temp Table 2 created successfully")</script>';
// } else {
//   echo "Error: " . $sql . "<br>" . $conn->error;
//   exit;
// }

// Create the stock_balance table if it doesn't exist
$sqlCreateTable = "CREATE TABLE IF NOT EXISTS stock_balance (
date_updated DATE,
store_name VARCHAR(255),
product_name VARCHAR(255),
stock_in INT,
received INT,
stock_out INT,
sales INT,
stock_balance INT,
opening_stock INT
)";

if ($conn->query($sqlCreateTable) === false) {
    echo "Error creating table: " . $conn->error;
    exit;
}

// Truncate the stock_balance table before populating new data
// $sqlTruncateTable = "TRUNCATE TABLE stock_balance";

// if ($conn->query($sqlTruncateTable) === false) {
//     echo "Error truncating table: " . $conn->error;
//     exit;
// }

// Get the distinct dates from the inventory table
$sqlDistinctDates = "SELECT DISTINCT date_updated FROM inventory ORDER BY date_updated";
$resultDistinctDates = $conn->query($sqlDistinctDates);

while ($rowDistinctDates = $resultDistinctDates->fetch_assoc()) {
$currentDate = $rowDistinctDates['date_updated'];

//Get the distinct store-product combinations
$sqlDistinctStoreProduct = "SELECT i.store_id, i.product_id
    FROM inventory i
    JOIN product_list pl ON i.product_id = pl.id
    JOIN stores s ON i.store_id = s.id
    GROUP BY i.store_id, i.product_id";
$resultDistinctStoreProduct = $conn->query($sqlDistinctStoreProduct);

while ($rowDistinctStoreProduct = $resultDistinctStoreProduct->fetch_assoc()) {
    $storeID = $rowDistinctStoreProduct['store_id'];
    $productID = $rowDistinctStoreProduct['product_id'];

    //Get the opening stock from the previous day balance  MAX(date_updated)
    $sqlOpeningStock = "SELECT stock_balance
        FROM stock_balance
        WHERE date_updated = DATE_SUB('$currentDate', INTERVAL 1 DAY)
            AND store_name = (SELECT store_name FROM stores WHERE id = $storeID)
            AND product_name = (SELECT name FROM product_list WHERE id = $productID)
        LIMIT 1";
    $resultOpeningStock = $conn->query($sqlOpeningStock);
    $openingStock = ($resultOpeningStock->num_rows > 0) ? $resultOpeningStock->fetch_assoc()['stock_balance'] : 0;

    // Get the stock movements for the current date and store-product combination
    $sqlStockMovements = "SELECT
        SUM(CASE WHEN type = 1 THEN qty ELSE 0 END) AS stock_in,
        SUM(CASE WHEN type = 3 THEN qty ELSE 0 END) AS received,
        SUM(CASE WHEN type = 4 THEN qty ELSE 0 END) AS stock_out,
        SUM(CASE WHEN type = 2 THEN qty ELSE 0 END) AS sales
        FROM inventory
        WHERE date_updated = '$currentDate'
            AND store_id = $storeID
            AND product_id = $productID";
    $resultStockMovements = $conn->query($sqlStockMovements);
    $rowStockMovements = $resultStockMovements->fetch_assoc();
    $stockIn = $rowStockMovements['stock_in'];
    $received = $rowStockMovements['received'];
    $stockOut = $rowStockMovements['stock_out'];
    $sales = $rowStockMovements['sales'];
    
    // Calculate the stock balance and closing stock
    $stockBalance = ($stockIn + $received) - ($stockOut - $sales);
    $closingStock = $stockBalance + $stockOut - $sales;

    // Insert the calculated values into the stock_balance table
    // $chk = $conn->query("SELECT * FROM stock_balance WHERE date_updated ='$currentDate' , MAX(date_updated)
    $chk = $conn->query("SELECT * FROM stock_balance WHERE date_updated ='$currentDate'
      AND store_name = (SELECT store_name FROM stores WHERE id = $storeID)
      AND product_name = (SELECT name FROM product_list WHERE id = $productID)");
    if($chk->num_rows > 0){
      // Data Exist Message
      //echo '<script>alert("Product have been captured for this date.")</script>';
    }else{
    $sql = "INSERT INTO stock_balance (date_updated, store_name, product_name, stock_in, received, stock_out, sales, stock_balance, opening_stock) 
    VALUES ('$currentDate',
        (SELECT store_name FROM stores WHERE id = $storeID),
        (SELECT name FROM product_list WHERE id = $productID),
        $stockIn,
        $received,
        $stockOut,
        $sales,
        $stockBalance,
        $openingStock)";
    if ($conn->query($sql) === TRUE) {
        echo '<script>alert("Record saved successfully")</script>';                          
      }else{
        //echo '<script>alert("Record failed to save")</script>';
                         
      }
   }
}
}

?>

<style>
  body{
        background:#C0C0C0;
  }
</style>

<div class="wrapper">
<div class="content-wrapper">
	<div class="container-fluid">
  <div class="content-header">
		<div class="container-fluid">
			<div class="row mb-2">
        <div class="col-sm-6">
          <h4 class="m-0">Onielsoft | Martvet</h4>
        </div><!-- /.col -->
        <div class="col-sm-6">
          <ol class="breadcrumb float-sm-right">
          <li class="breadcrumb-item"><a href="index.php">Home</a></li>
          <li class="breadcrumb-item active">Store Value</li>
          </ol>
        </div><!-- /.col -->
			</div><!-- /.row -->
		</div><!-- /.container-fluid -->
		</div>
	
    <div class="col-md-12">
      <div class="card card-outline card-info">
        <div class="card-header">
        <?php $todate = date('d-M-Y');?>
            <h2 class="card-title"><b>Stock Value as at <?php echo $todate ?> | By Store</b></h2>

            <div class="card-tools">
              <button type="button" class="btn btn-tool" data-card-widget="collapse">
                <i class="fas fa-minus"></i>
              </button>
              <button type="button" class="btn btn-tool" data-card-widget="remove">
                <i class="fas fa-times"></i>
              </button>
            </div>
        </div>
        <div class="card-body">
        <form action="" method="post">
          <div class="row">
          
            <div class="form-group col-md-3">
            <label class="control-label">Store</label>
            <select name="stock_store" id="" class="custom-select browser-default select2">
            <option value=""></option>
            <?php 
              $store = $conn->query("SELECT * FROM stores order by store_name asc");
              while($row=$store->fetch_assoc()):
            ?>
              <option value="<?php echo $row['id'] ?>"><?php echo $row['store_name'] ?></option>
            <?php endwhile; ?>
            </select>
            </div>
            <div class="col-md-2">
            <div class="form-group">
            <label for="" class="control-label" style="color: white"> Search  </label>
              <button name="stock" class="btn btn-block btn-info btn-sm"><i class="fa fa-search"></i> Search</button>
            </div>
            </div>

          </div>  
        </form>
          <table id="resultTable" class="table table-bordered table-striped"> 
          <thead>
            <th class="text-center">#</th>
            <th class="text-left">SKU</th>
            <th class="text-left">Product Name</th>
            <th class="text-center">Selling Price</th>
            <th class="text-center">Available Qty</th>
            <th class="text-center">Total Amount</th>
          </thead>
            <tbody>
            <?php 
              if(isset($_POST['stock_store']) && isset($_POST['stock'])){
              $branch = $_POST['stock_store'];
              $ava_stock = 0;
              $cum_qty = 0;
              $cum_amount = 0;
              $total_sprice = 0;
              $total_cprice = 0;

              $i = 1;
            
              $product = $conn->query("SELECT * FROM product_list WHERE `store_id` = '$branch' AND product_status = 1 ORDER BY name ASC LIMIT 1000");
              $name = "";
              while($row_p=$product->fetch_assoc())
              {
                $name = $row_p['name'];
                $sku = $row_p['sku'];
                $selling_price = $row_p['price'];
              
              $sin = $conn->query("SELECT sum(qty) as `sin` FROM inventory WHERE `type` = 1 AND `store_id` = '$branch' AND product_id = ".$row_p['id']);
              $sin = $sin && $sin->num_rows > 0 ? $sin->fetch_array()['sin'] : 0;
              $sout = $conn->query("SELECT sum(qty) as `sout` FROM inventory WHERE `type` = 2 AND `store_id` = '$branch' AND product_id = ".$row_p['id']);
              $sout = $sout && $sout->num_rows > 0 ? $sout->fetch_array()['sout'] : 0;
              
              $ava_stock = $sin - $sout;
              $total_sprice = ($selling_price * $ava_stock); 
              
              $cum_qty += $ava_stock;
              $cum_amount += $total_sprice;

              ?>
                <tr>
                  <td class="text-center"><?php echo $i++ ?></td>
                  <td class=""><?php echo $sku; ?></td>
                  <td class=""><?php echo $name; ?></td>
                  <td class="text-right"><?php echo "&#8358; ".number_format($selling_price, 2) ?></td>
                  <td class="text-right"><?php echo number_format( $ava_stock) ?></td>
                  <td class="text-right"><?php echo "&#8358; ".number_format($total_sprice, 2) ?></td>
                </tr>
              <?php };

                }else{

                  $ava_stock = 0;
                  $cum_qty = 0;
                  $cum_amount = 0;
                  $total_price = 0;

                  $i = 1;
                
                  $product = $conn->query("SELECT * FROM product_list WHERE `store_id` = 2 AND product_status = 1 ORDER BY name ASC LIMIT 1000");
                  $name = "";
                  while($row_p=$product->fetch_assoc())
                  {
                    $name = $row_p['name'];
                    $sku = $row_p['sku'];
                    $selling_price = $row_p['price'];
                  
                  $sin = $conn->query("SELECT sum(qty) as `sin` FROM inventory WHERE `type` = 1 AND `store_id` = 2 AND product_id = ".$row_p['id']);
                  $sin = $sin && $sin->num_rows > 0 ? $sin->fetch_array()['sin'] : 0;
                  $sout = $conn->query("SELECT sum(qty) as `sout` FROM inventory WHERE `type` = 2 AND `store_id` = 2 AND product_id = ".$row_p['id']);
                  $sout = $sout && $sout->num_rows > 0 ? $sout->fetch_array()['sout'] : 0;
                  
                  $ava_stock = $sin - $sout;
                  $total_price = ($selling_price * $ava_stock); 
                  
                  $cum_qty += $ava_stock;
                  $cum_amount += $total_price;

                ?>
                <tr>
                  <td class="text-center"><?php echo $i++ ?></td>
                  <td class=""><?php echo $sku; ?></td>
                  <td class=""><?php echo $name; ?></td>
                  <td class="text-right"><?php echo "&#8358; ".number_format($selling_price, 2) ?></td>
                  <td class="text-right"><?php echo number_format( $ava_stock) ?></td>
                  <td class="text-right"><?php echo "&#8358; ".number_format($total_price, 2) ?></td>
                  
                </tr>

                <?php }; }?>
            </tbody>
            <tfoot>
            <tr>
              <td class="text-right" colspan="4">Cumulative Total</td>
              <td class="text-right"><?php echo number_format($cum_qty,1) ?></td>
              <td class="text-right"><?php echo "&#8358; ".number_format( $cum_amount,2) ?></td>
            </tr>
          </tfoot>
          </table>
        </div>
      </div>
    </div>

  </div>
</div>
</div>


<script src="./plugins/datatables/jquery.dataTables.min.js"></script>
<script src="./plugins/datatables-bs4/js/dataTables.bootstrap4.min.js"></script>
<script src="./plugins/datatables-responsive/js/dataTables.responsive.min.js"></script>
<script src="./plugins/datatables-responsive/js/responsive.bootstrap4.min.js"></script>
<script src="./plugins/datatables-buttons/js/dataTables.buttons.min.js"></script>
<script src="./plugins/datatables-buttons/js/buttons.bootstrap4.min.js"></script>
<script src="./plugins/jszip/jszip.min.js"></script>
<script src="./plugins/pdfmake/pdfmake.min.js"></script>
<script src="./plugins/pdfmake/vfs_fonts.js"></script>
<script src="./plugins/datatables-buttons/js/buttons.html5.min.js"></script>
<script src="./plugins/datatables-buttons/js/buttons.print.min.js"></script>
<script src="./plugins/datatables-buttons/js/buttons.colVis.min.js"></script>

<script src="http://code.jquery.com/ui/1.10.3/jquery-ui.js"></script>

<!-- Select2 -->
<script src="./plugins/select2/js/select2.full.min.js"></script>
<!-- Bootstrap4 Duallistbox -->
<script src="./plugins/bootstrap4-duallistbox/jquery.bootstrap-duallistbox.min.js"></script>
<!-- InputMask -->
<script src="./plugins/moment/moment.min.js"></script>
<script src="./plugins/inputmask/jquery.inputmask.min.js"></script>
<!-- date-range-picker -->
<script src="./plugins/daterangepicker/daterangepicker.js"></script>
<!-- bootstrap color picker -->
<script src="./plugins/bootstrap-colorpicker/js/bootstrap-colorpicker.min.js"></script>
<!-- Tempusdominus Bootstrap 4 -->
<script src="./plugins/tempusdominus-bootstrap-4/js/tempusdominus-bootstrap-4.min.js"></script>
<!-- Bootstrap Switch -->
<script src="./plugins/bootstrap-switch/js/bootstrap-switch.min.js"></script>
<!-- BS-Stepper -->
<script src="./plugins/bs-stepper/js/bs-stepper.min.js"></script>
<!-- dropzonejs -->
<script src="./plugins/dropzone/min/dropzone.min.js"></script>


<script>

  //Date picker
  $('#reservationdate').datetimepicker({
        format: 'MM/DD/YYYY'
    });

	$('#reservationdate1').datetimepicker({
		format: 'MM/DD/YYYY'
        // format: 'L'
    });
</script>



<script>
 
  $(function () {
    $("#resultTable").DataTable({
      "responsive": true, "lengthChange": false, "autoWidth": false,
      "buttons": ["copy", "csv", "excel", "pdf", "print", "colvis"]
    }).buttons().container().appendTo('#resultTable_wrapper .col-md-6:eq(0)');
    $('#example2').DataTable({
      "paging": true,
      "lengthChange": false,
      "searching": false,
      "ordering": true,
      "info": true,
      "autoWidth": false,
      "responsive": true,
    });
  });
</script>