<?php 
    include './private/db_connect.php'; 

    $i = 1;
    $dsDate = date('Y-m-d');  // Get current date
    $queryCondition = "";
    $post_at = "";
    $post_at_to_date = "";

    // Ensure session store_id is set
    $store_id = $_SESSION['login_store_id'] ?? 1; 

    // Handle date selection
    if (!empty($_POST["search"]["post_at"])) {			
        $post_at = date('Y-m-d', strtotime($_POST["search"]["post_at"]));
        $post_at_to_date = $post_at; // Default to same day if no end date

        if (!empty($_POST["search"]["post_at_to_date"])) {
            $post_at_to_date = date('Y-m-d', strtotime($_POST["search"]["post_at_to_date"]));
        }

        // Apply date filter
        $queryCondition = "AND DATE(inventory.date_updated) BETWEEN '$post_at' AND '$post_at_to_date'";
    } else {
        // Default: Load today's data
        $queryCondition = "AND DATE(inventory.date_updated) = '$dsDate'";
    }

    // Query to fetch grouped sales
    $sql = "SELECT 
                inventory.product_id, 
                DATE(inventory.date_updated) AS sales_date, 
                SUM(inventory.qty) AS total_qty, 
                SUM(inventory.amount) AS total_amount, 
                COALESCE(product_list.name, 'Unknown') AS product_name
            FROM inventory
            LEFT JOIN product_list ON inventory.product_id = product_list.id
            WHERE inventory.store_id = ? 
            AND inventory.type = 2  
            $queryCondition
            GROUP BY inventory.product_id, sales_date
            ORDER BY inventory.date_updated DESC";

    // Prepare statement
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("i", $store_id);
    $stmt->execute();
    $result = $stmt->get_result();
?>

    <!-- HTML FORM -->
    <div class="wrapper">
    <div class="content-wrapper">
        <div class="container-fluid">

            <div class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0">Onielsoft | Martvet</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="index.php">Home</a></li>
                    <li class="breadcrumb-item active">Sales by Product</li>
                    </ol>
                </div>
                </div>
            </div>
            </div>

            <div class="col-md-12">
            <div class="card card-outline card-warning">
                <div class="card-header">
                    <h2 class="card-title"><b>Sales by Product</b></h2>

                    <div class="card-tools">
                    <button type="button" class="btn btn-tool" data-card-widget="collapse">
                        <i class="fas fa-minus"></i>
                    </button>
                    <button type="button" class="btn btn-tool" data-card-widget="remove">
                        <i class="fas fa-times"></i>
                    </button>
                    </div>
                </div>
                        <div class="card-body">
                        
                <form name="frmSearch" method="post" action="">
                    <p class="search_input">
                    <div class="row">
                    <div class="col-sm-3">
                        <div class="form-group">
                        <label class="control-label">Start Date:</label>
                        <div class="input-group date" id="reservationdate" data-target-input="nearest">
                            <input type="text" id="post_at" name="search[post_at]" class="form-control form-control-sm datetimepicker-input" autocomplete="off" data-target="#reservationdate"/>
                            <div class="input-group-append" data-target="#reservationdate" data-toggle="datetimepicker">
                            <div class="input-group-text"><i class="fa fa-calendar"></i></div>
                            </div>
                        </div>
                        </div>
                    </div>
                    <div class="col-sm-3">
                        <div class="form-group">
                        <label class="control-label">End Date:</label>
                        <div class="input-group date" id="reservationdate1" data-target-input="nearest">
                            <input type="text" id="post_at_to_date" name="search[post_at_to_date]" class="form-control form-control-sm datetimepicker-input" autocomplete="off" data-target="#reservationdate1"/>
                            <div class="input-group-append" data-target="#reservationdate1" data-toggle="datetimepicker">
                            <div class="input-group-text"><i class="fa fa-calendar"></i></div>
                            </div>
                        </div>
                        </div>
                    </div>
                    <div class="col-sm-2">
                        <div class="form-group">
                        <label for="" class="control-label" style="color: white"> Search  </label>
                        <button type="submit" class="btn btn-block btn-info btn-sm" name="go" value="Search"><i class="fa fa-search"></i> Search</button> 
                        </div>
                    </div>
                    </div>
                    </p>
                </form> 

            <?php if(!empty($result)) { ?>         
            <table class="table table-bordered" id="resultTable">
                    <thead>
                    <th class="text-center">Sn</th>
                    <th class="text-center">Date</th>
                    <th class="text-center">Product Name</th>
                    <th class="text-center">Qty</th>
                    <th class="text-center">Total Amount</th>
                    </thead>
                <tbody> 

                <?php   
                while($row = $result->fetch_assoc()) { 
                ?>
                    <tr>
                        <td class="text-center"><?php echo $i++ ?></td>
                        <td class=""><?php echo date('Y-m-d', strtotime($row['sales_date'])) ?></td>
                        <td class=""><?php echo $row['product_name']; ?></td>
                        <td class="text-right"><?php echo number_format($row['total_qty']) ?></td>
                        <td class="text-right"><?php echo number_format($row['total_amount']) ?></td>
                    </tr>
                    <?php } ?>
                </tbody>
                </table>
                <?php } ?> 
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>



<script src="http://code.jquery.com/ui/1.10.3/jquery-ui.js"></script> 

<!-- jQuery -->
<script src="./plugins/jquery/jquery.min.js"></script>
<!-- Bootstrap 4 -->
<script src="./plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
<!-- Select2 -->
<script src="./plugins/select2/js/select2.full.min.js"></script>
<!-- Bootstrap4 Duallistbox -->
<script src="./plugins/bootstrap4-duallistbox/jquery.bootstrap-duallistbox.min.js"></script>
<!-- InputMask -->
<script src="./plugins/moment/moment.min.js"></script>
<script src="./plugins/inputmask/jquery.inputmask.min.js"></script>
<!-- date-range-picker -->
<script src="./plugins/daterangepicker/daterangepicker.js"></script>
<!-- bootstrap color picker -->
<script src="./plugins/bootstrap-colorpicker/js/bootstrap-colorpicker.min.js"></script>
<!-- Tempusdominus Bootstrap 4 -->
<script src="./plugins/tempusdominus-bootstrap-4/js/tempusdominus-bootstrap-4.min.js"></script>
<!-- Bootstrap Switch -->
<script src="./plugins/bootstrap-switch/js/bootstrap-switch.min.js"></script>
<!-- BS-Stepper -->
<script src="./plugins/bs-stepper/js/bs-stepper.min.js"></script>
<!-- dropzonejs -->
<script src="./plugins/dropzone/min/dropzone.min.js"></script>

<!-- DataTables  & Plugins -->

<script src="./plugins/datatables/jquery.dataTables.min.js"></script>
<script src="./plugins/datatables-bs4/js/dataTables.bootstrap4.min.js"></script>
<script src="./plugins/datatables-responsive/js/dataTables.responsive.min.js"></script>
<script src="./plugins/datatables-responsive/js/responsive.bootstrap4.min.js"></script>
<script src="./plugins/datatables-buttons/js/dataTables.buttons.min.js"></script>
<script src="./plugins/datatables-buttons/js/buttons.bootstrap4.min.js"></script>
<script src="./plugins/jszip/jszip.min.js"></script>
<script src="./plugins/pdfmake/pdfmake.min.js"></script>
<script src="./plugins/pdfmake/vfs_fonts.js"></script>
<script src="./plugins/datatables-buttons/js/buttons.html5.min.js"></script>
<script src="./plugins/datatables-buttons/js/buttons.print.min.js"></script>
<script src="./plugins/datatables-buttons/js/buttons.colVis.min.js"></script>

<script>
  $(function () {
    $("#resultTable").DataTable({
      "responsive": true, "lengthChange": false, "autoWidth": false,
      "buttons": ["copy", "csv", "excel", "pdf", "print", "colvis"]
    }).buttons().container().appendTo('#resultTable_wrapper .col-md-6:eq(0)');
    $('#example2').DataTable({
      "paging": true,
      "lengthChange": false,
      "searching": false,
      "ordering": true,
      "info": true,
      "autoWidth": false,
      "responsive": true,
    });
  });
</script>

<script>
  $(function () {
    //Initialize Select2 Elements
	//$("#product").val('0').trigger('change');
    $('.select2').select2()

    //Initialize Select2 Elements
    $('.select2bs4').select2({
      theme: 'bootstrap4'
    })

    //Datemask dd/mm/yyyy
    $('#datemask').inputmask('dd/mm/yyyy', { 'placeholder': 'dd/mm/yyyy' })
    //Datemask2 mm/dd/yyyy
    $('#datemask2').inputmask('mm/dd/yyyy', { 'placeholder': 'mm/dd/yyyy' })
    //Money Euro
    $('[data-mask]').inputmask()

    //Date picker
    $('#reservationdate').datetimepicker({
        format: 'MM/DD/YYYY'
    });

	$('#reservationdate1').datetimepicker({
		format: 'MM/DD/YYYY'
        // format: 'L'
    });

    //Date and time picker
    $('#reservationdatetime').datetimepicker({ icons: { time: 'far fa-clock' } });

    //Date range picker
    $('#reservation').daterangepicker()
    //Date range picker with time picker
    $('#reservationtime').daterangepicker({
      timePicker: true,
      timePickerIncrement: 30,
      locale: {
        format: 'MM/DD/YYYY hh:mm A'
      }
    })
    //Date range as a button
    $('#daterange-btn').daterangepicker(
      {
        ranges   : {
          'Today'       : [moment(), moment()],
          'Yesterday'   : [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
          'Last 7 Days' : [moment().subtract(6, 'days'), moment()],
          'Last 30 Days': [moment().subtract(29, 'days'), moment()],
          'This Month'  : [moment().startOf('month'), moment().endOf('month')],
          'Last Month'  : [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
        },
        startDate: moment().subtract(29, 'days'),
        endDate  : moment()
      },
      function (start, end) {
        $('#reportrange span').html(start.format('MMMM D, YYYY') + ' - ' + end.format('MMMM D, YYYY'))
      }
    )

    //Timepicker
    $('#timepicker').datetimepicker({
      format: 'LT'
    })

    //Bootstrap Duallistbox
    $('.duallistbox').bootstrapDualListbox()

    //Colorpicker
    $('.my-colorpicker1').colorpicker()
    //color picker with addon
    $('.my-colorpicker2').colorpicker()

    $('.my-colorpicker2').on('colorpickerChange', function(event) {
      $('.my-colorpicker2 .fa-square').css('color', event.color.toString());
    })

    $("input[data-bootstrap-switch]").each(function(){
      $(this).bootstrapSwitch('state', $(this).prop('checked'));
    })

  })
  // BS-Stepper Init
  document.addEventListener('DOMContentLoaded', function () {
    window.stepper = new Stepper(document.querySelector('.bs-stepper'))
  })

  // DropzoneJS Demo Code Start
  Dropzone.autoDiscover = false

  // Get the template HTML and remove it from the doumenthe template HTML and remove it from the doument
  var previewNode = document.querySelector("#template")
  previewNode.id = ""
  var previewTemplate = previewNode.parentNode.innerHTML
  previewNode.parentNode.removeChild(previewNode)

  var myDropzone = new Dropzone(document.body, { // Make the whole body a dropzone
    url: "/target-url", // Set the url
    thumbnailWidth: 80,
    thumbnailHeight: 80,
    parallelUploads: 20,
    previewTemplate: previewTemplate,
    autoQueue: false, // Make sure the files aren't queued until manually added
    previewsContainer: "#previews", // Define the container to display the previews
    clickable: ".fileinput-button" // Define the element that should be used as click trigger to select files.
  })

  myDropzone.on("addedfile", function(file) {
    // Hookup the start button
    file.previewElement.querySelector(".start").onclick = function() { myDropzone.enqueueFile(file) }
  })

  // Update the total progress bar
  myDropzone.on("totaluploadprogress", function(progress) {
    document.querySelector("#total-progress .progress-bar").style.width = progress + "%"
  })

  myDropzone.on("sending", function(file) {
    // Show the total progress bar when upload starts
    document.querySelector("#total-progress").style.opacity = "1"
    // And disable the start button
    file.previewElement.querySelector(".start").setAttribute("disabled", "disabled")
  })

  // Hide the total progress bar when nothing's uploading anymore
  myDropzone.on("queuecomplete", function(progress) {
    document.querySelector("#total-progress").style.opacity = "0"
  })

  // Setup the buttons for all transfers
  // The "add files" button doesn't need to be setup because the config
  // `clickable` has already been specified.
  document.querySelector("#actions .start").onclick = function() {
    myDropzone.enqueueFiles(myDropzone.getFilesWithStatus(Dropzone.ADDED))
  }
  document.querySelector("#actions .cancel").onclick = function() {
    myDropzone.removeAllFiles(true)
  }
  // DropzoneJS Demo Code End
</script>
<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>