
<!DOCTYPE html>
<html>
<head>
<meta charset="UTF-8">
<title>Insert title here</title>

<style>
table {
    font-family: arial, sans-serif;
    border-collapse: collapse;
    width: 100%;
}

td, th {
    border: 1px solid #dddddd;
    text-align: left;
    padding: 8px;
}

tr:nth-child(even) {
    background-color: #dddddd;
}
</style>

</head>
<body>

<table id="preview-table">
  <tr>
    <th>Company</th>
    <th>Contact</th>
    <th>Country</th>
  </tr>
  <tr>
    <td>Alfreds Futterkiste</td>
    <td>Maria Anders</td>
    <td>Germany</td>
  </tr>
  <tr>
    <td>Centro comercial Moctezuma</td>
    <td>Francisco Chang</td>
    <td>Mexico</td>
  </tr>
  <tr>
    <td>Ernst Handel</td>
    <td>Roland Mendel</td>
    <td>Austria</td>
  </tr>
  <tr>
    <td>Island Trading</td>
    <td>Helen Bennett</td>
    <td>UK</td>
  </tr>
  <tr>
    <td>Laughing Bacchus Winecellars</td>
    <td>Yoshi Tannamuri</td>
    <td>Canada</td>
  </tr>
  <tr>
    <td>Magazzini Alimentari Riuniti</td>
    <td>Giovanni Rovelli</td>
    <td>Italy</td>
  </tr>
</table>


<button id="export">Table Export</button>

<script src="https://ajax.googleapis.com/ajax/libs/jquery/1.11.1/jquery.min.js"></script>
<script type="text/javascript" src="tableExport.js"></script>
<script type="text/javascript" src="html2canvas.js"></script>

<script type="text/javascript">

$('#export').on('click', function() {
	console.log('exporting');
	//$('#preview-table').tableExport({type:'png',escape:'false'});

	html2canvas($('#preview-table'), {
		onrendered: function(canvas) {										
			var img = canvas.toDataURL("image/png");
			//var img = canvas.toDataURL("application/octet-stream");
			
			function saveAs(uri, filename) {
			    var link = document.createElement('a');
			    if (typeof link.download === 'string') {
			        document.body.appendChild(link); // Firefox requires the link to be in the body
			        link.download = filename;
			        link.href = uri;
			        link.click();
			        document.body.removeChild(link); // remove the link when done
			    } else {
			        location.replace(uri);
			    }
			}
			
			var uri = img.replace(/^data:image\/[^;]/, 'data:application/octet-stream');
			//window.open(url);
			saveAs(uri, 'tableExport.png');
			
			
		}
	});	
});


</script>


</body>
</html>