<?php 
include './private/db_connect.php';
        
if(!isset($_SESSION['login_id']))
  header('location:login.php');
  include('./private/header.php');

?>


<div class="wrapper">
<div class="content-wrapper">
	<div class="container-fluid">
  		<div class="content-header">
		<div class="container-fluid">
			<div class="row mb-2">
			<div class="col-sm-6">
				<h4 class="m-0">Onielsoft | POS</h4>
			</div><!-- /.col -->
			<div class="col-sm-6">
				<ol class="breadcrumb float-sm-right">
				<li class="breadcrumb-item"><a href="index.php">Home</a></li>
				<li class="breadcrumb-item active">Sales Summary Report</li>
				</ol>
			</div><!-- /.col -->
			</div><!-- /.row -->
		</div><!-- /.container-fluid -->
		</div>
    <div class="row">
    <div class="col-md-12">
		<div class="card card-outline card-warning">
			<div class="card-header">
				<h2 class="card-title"><b>Daily Sales Summary Report</b></h2>

				<div class="card-tools">
				<button type="button" class="btn btn-tool" data-card-widget="collapse">
					<i class="fas fa-minus"></i>
				</button>
				<button type="button" class="btn btn-tool" data-card-widget="remove">
					<i class="fas fa-times"></i>
				</button>
				</div>
			</div>
        <div class="card-body">

        <div class="row">
        <div class="col-md-12">
        <form class="form-inline" method="POST" action="">
        <!-- <form class="form-inline" id ="searchForm"> -->
          <div class="row">
          <?php if($_SESSION['login_type'] == 1 OR $_SESSION['login_type'] == 11): ?>
              <div class="col-md-4">
                <div class="form-group">
                    <label class="control-label">Store:</label>
                    <select name="store_id" id="" class="form-control form-control-sm select2" data-placeholder="Select a Store" style="width: 100%;">
                        <option value=""></option>
                    <?php 
                        $stores = $conn->query("SELECT * FROM stores order by store_name asc");
                        while($row=$stores->fetch_assoc()):
                    ?>
                        <option value="<?php echo $row['id'] ?>"><?php echo $row['store_name'] ?></option>
                    <?php endwhile; ?>
                    </select>
                    </div>
                </div>
          <?php endif; ?>
          <?php if($_SESSION['login_type'] == 2 OR $_SESSION['login_type'] == 4): ?>
              <div class="col-md-4">
                <div class="form-group">
                    <label class="control-label">Store:</label>
                    <select name="store_id" id="" class="form-control form-control-sm select2" data-placeholder="Select a Store" style="width: 100%;">
                        <option value=""></option>
                    <?php 
                        $stores = $conn->query("SELECT * FROM stores WHERE id = '".$_SESSION['login_store_id']."' ORDER BY store_name asc");
                        while($row=$stores->fetch_assoc()):
                    ?>
                        <option value="<?php echo $row['id'] ?>"><?php echo $row['store_name'] ?></option>
                    <?php endwhile; ?>
                    </select>
                    </div>
                </div>
          <?php endif; ?>

            <div class="col-md-3">
              <div class="form-group">
                <label for="" class="control-label">Date : </label>
                <div class="input-group date" id="reservationdate" data-target-input="nearest">
                    <input type="text" name="date1" value="<?php echo isset($_POST['date1']) ? $_POST['date1'] : '' ?>" class="form-control form-control-sm datetimepicker-input" autocomplete="off" data-target="#reservationdate"/>
                    <div class="input-group-append" data-target="#reservationdate" data-toggle="datetimepicker">
                        <div class="input-group-text"><i class="fa fa-calendar"></i></div>
                    </div>
                </div>
              </div>
            </div>
            <div class="col-md-3">
              <div class="form-group">
                <label for="" class="control-label">To : </label>
                <div class="input-group date" id="reservationdate1" data-target-input="nearest">
                    <input type="text" name="date2" value="<?php echo isset($_POST['date2']) ? $_POST['date2'] : '' ?>" class="form-control form-control-sm datetimepicker-input" autocomplete="off" data-target="#reservationdate1"/>
                    <div class="input-group-append" data-target="#reservationdate1" data-toggle="datetimepicker">
                        <div class="input-group-text"><i class="fa fa-calendar"></i></div>
                    </div>
                </div>
              </div>
            </div>
           
            <div class="col-sm-2">
              <div class="form-group">
                <label class="control-label">&nbsp</label>
                <button name="search" class="btn btn-block btn-info btn-sm"><i class="fa fa-search"></i> Search</button>
                <!-- <button type="button" id ="search" name="search" class="btn btn-block btn-info btn-sm"><i class="fa fa-search"></i> Search</button> -->
              </div>
            </div>
          </div>
        </form>
        <br /><br />
    <table class="table table-bordered table-striped" id="load_table">
    <thead>
        <th class="text-center">#</th>
        <th class="text-left">Date</th>
        <th class="text-left">Store</th>
        <th class="text-left">Cashier Name</th>
        <th class="text-right">Cash</th>
        <th class="text-right">POS</th>
        <th class="text-right">Transfer</th>
        <!-- <th class="text-right">Total Amount</th> -->
    </thead>
    <tbody>  
        <?php
        // Retrieve POST data
        $i = 1;
        $cum_sales = array(); // Array to store cumulative sales for each user_id

        if (isset($_POST['search'])) {
            $date = date("Y-m-d", strtotime($_POST['date1']));
            $date2 = date("Y-m-d", strtotime($_POST['date2']));
            $storeId = $_POST['store_id'];

            $sql = mysqli_query($conn, "SELECT
                CAST(`s`.`date_updated` AS DATE) AS `date_updated`,
                `s`.`mpay_id` AS `mpay_id`,
                `b`.`id` AS `store_id`,
                `u`.`id` AS `user_id`,
                `b`.`store_name` AS `store_name`,
                `u`.`names` AS `cashier`,
                SUM(CASE WHEN `s`.`mpay_id` = '1' THEN `s`.`total_amount` ELSE 0 END) AS `cash`,
                SUM(CASE WHEN `s`.`mpay_id` = '2' THEN `s`.`total_amount` ELSE 0 END) AS `pos`,
                SUM(CASE WHEN `s`.`mpay_id` = '3' THEN `s`.`total_amount` ELSE 0 END) AS `transfer`,
                SUM(CASE WHEN `s`.`mpay_id` = '0' THEN `s`.`total_amount` ELSE 0 END) AS `others`
                FROM `martvet_db`.`sales_list` `s` 
                JOIN `martvet_db`.`stores` `b` ON `b`.`id` = `s`.`store_id`
                JOIN `martvet_db`.`users` `u` ON `u`.`id` = `s`.`user_id`
                WHERE `s`.`store_id` = '$storeId' AND DATE(`s`.`date_updated`) BETWEEN '$date' AND '$date2'
                GROUP BY `u`.`id`");

            if ($sql) {
                while ($fetch = mysqli_fetch_array($sql)) {
                    $total_sales = $fetch['cash'] + $fetch['pos'] + $fetch['transfer'] + $fetch['others'];
                    $cum_sales[$fetch['user_id']] = isset($cum_sales[$fetch['user_id']]) ? $cum_sales[$fetch['user_id']] + $total_sales : $total_sales;
                    ?>
                    <tr>
                        <td class="text-center"><?php echo $i++ ?></td> 
                        <td><?php echo date("d-m-Y", strtotime($fetch['date_updated'])); ?></td>
                        <td class="text-left"><?php echo ($fetch['store_name']) ?></td>
                        <td class="text-left"><?php echo ($fetch['cashier']) ?></td>
                        <td class="text-right"><?php echo "&#8358; " . number_format($fetch['cash'], 2) ?></td>
                        <td class="text-right"><?php echo "&#8358; " . number_format($fetch['pos'], 2) ?></td>
                        <td class="text-right"><?php echo "&#8358; " . number_format($fetch['transfer'], 2) ?></td> 
                        <!-- <td class="text-right"></?php echo "&#8358; " . number_format($total_sales, 2) ?></td> -->
                    </tr>
                    <?php
                }
            }
        }
        ?>
        </tbody>
        <tfoot>
        <?php
          foreach ($cum_sales as $user_id => $cumulative_total) {
              $cashier_name = ''; // Initialize cashier name
              // Query the database to get the cashier name based on user_id
              $user_query = mysqli_query($conn, "SELECT `names` FROM `martvet_db`.`users` WHERE `id` = '$user_id'");
              if ($user_query && mysqli_num_rows($user_query) > 0) {
                  $user_data = mysqli_fetch_assoc($user_query);
                  $cashier_name = $user_data['names'];
              }
              ?>
              <tr>
                  <td colspan="6" class="text-right"><b><?php echo $cashier_name ?></b></td>
                  <td class="text-right"><b><?php echo "&#8358; " . number_format($cumulative_total, 2) ?></b></td>
              </tr>
              <?php
          }
        ?>

        </tfoot>
    </table>

            
          </div>
          </div>
      </div>
    </div>
    </div>
    </div>
    </div>
    </div>
  </div>
</div>


<!-- jQuery -->
<script src="./plugins/jquery/jquery.min.js"></script>
<!-- Bootstrap 4 -->
<script src="./plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
<!-- Select2 -->
<script src="./plugins/select2/js/select2.full.min.js"></script>
<!-- Bootstrap4 Duallistbox -->
<script src="./plugins/bootstrap4-duallistbox/jquery.bootstrap-duallistbox.min.js"></script>
<!-- InputMask -->
<script src="./plugins/moment/moment.min.js"></script>
<script src="./plugins/inputmask/jquery.inputmask.min.js"></script>
<!-- date-range-picker -->
<script src="./plugins/daterangepicker/daterangepicker.js"></script>
<!-- bootstrap color picker -->
<script src="./plugins/bootstrap-colorpicker/js/bootstrap-colorpicker.min.js"></script>
<!-- Tempusdominus Bootstrap 4 -->
<script src="./plugins/tempusdominus-bootstrap-4/js/tempusdominus-bootstrap-4.min.js"></script>
<!-- Bootstrap Switch -->
<script src="./plugins/bootstrap-switch/js/bootstrap-switch.min.js"></script>
<!-- BS-Stepper -->
<script src="./plugins/bs-stepper/js/bs-stepper.min.js"></script>
<!-- dropzonejs -->
<script src="./plugins/dropzone/min/dropzone.min.js"></script>


<!-- DataTables  & Plugins -->
<script src="./plugins/datatables/jquery.dataTables.min.js"></script>
<script src="./plugins/datatables-bs4/js/dataTables.bootstrap4.min.js"></script>
<script src="./plugins/datatables-responsive/js/dataTables.responsive.min.js"></script>
<script src="./plugins/datatables-responsive/js/responsive.bootstrap4.min.js"></script>
<script src="./plugins/datatables-buttons/js/dataTables.buttons.min.js"></script>
<script src="./plugins/datatables-buttons/js/buttons.bootstrap4.min.js"></script>
<script src="./plugins/jszip/jszip.min.js"></script>
<script src="./plugins/pdfmake/pdfmake.min.js"></script>
<script src="./plugins/pdfmake/vfs_fonts.js"></script>
<script src="./plugins/datatables-buttons/js/buttons.html5.min.js"></script>
<script src="./plugins/datatables-buttons/js/buttons.print.min.js"></script>
<script src="./plugins/datatables-buttons/js/buttons.colVis.min.js"></script>

<script>
  $(function () {
    $("#load_table").DataTable({
      "responsive": true, "lengthChange": false, "autoWidth": false,
      "buttons": ["copy", "csv", "excel", "pdf", "print", "colvis"]
    }).buttons().container().appendTo('#load_table_wrapper .col-md-6:eq(0)');
    $('#example2').DataTable({
      "paging": true,
      "lengthChange": false,
      "searching": true,
      "ordering": true,
      "info": true,
      "autoWidth": false,
      "responsive": true,
    });

    $('#example1').DataTable({
      "paging": true,
      "lengthChange": false,
      "searching": true,
      "ordering": true,
      "info": true,
      "autoWidth": false,
      "responsive": true,
    });
  });

 
</script>


<script>
  $(function () {
    //Initialize Select2 Elements
	//$("#product").val('0').trigger('change');
    $('.select2').select2()

    //Initialize Select2 Elements
    $('.select2bs4').select2({
      theme: 'bootstrap4'
    })

    //Datemask dd/mm/yyyy
    $('#datemask').inputmask('dd/mm/yyyy', { 'placeholder': 'dd/mm/yyyy' })
    //Datemask2 mm/dd/yyyy
    $('#datemask2').inputmask('mm/dd/yyyy', { 'placeholder': 'mm/dd/yyyy' })
    //Money Euro
    $('[data-mask]').inputmask()

    //Date picker
    $('#reservationdate').datetimepicker({
        format: 'MM/DD/YYYY'
    });

	$('#reservationdate1').datetimepicker({
		format: 'MM/DD/YYYY'
        // format: 'L'
    });

    //Date and time picker
    $('#reservationdatetime').datetimepicker({ icons: { time: 'far fa-clock' } });

    //Date range picker
    $('#reservation').daterangepicker()
    //Date range picker with time picker
    $('#reservationtime').daterangepicker({
      timePicker: true,
      timePickerIncrement: 30,
      locale: {
        format: 'MM/DD/YYYY hh:mm A'
      }
    })
    //Date range as a button
    $('#daterange-btn').daterangepicker(
      {
        ranges   : {
          'Today'       : [moment(), moment()],
          'Yesterday'   : [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
          'Last 7 Days' : [moment().subtract(6, 'days'), moment()],
          'Last 30 Days': [moment().subtract(29, 'days'), moment()],
          'This Month'  : [moment().startOf('month'), moment().endOf('month')],
          'Last Month'  : [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
        },
        startDate: moment().subtract(29, 'days'),
        endDate  : moment()
      },
      function (start, end) {
        $('#reportrange span').html(start.format('MMMM D, YYYY') + ' - ' + end.format('MMMM D, YYYY'))
      }
    )

    //Timepicker
    $('#timepicker').datetimepicker({
      format: 'LT'
    })

    //Bootstrap Duallistbox
    $('.duallistbox').bootstrapDualListbox()

    //Colorpicker
    $('.my-colorpicker1').colorpicker()
    //color picker with addon
    $('.my-colorpicker2').colorpicker()

    $('.my-colorpicker2').on('colorpickerChange', function(event) {
      $('.my-colorpicker2 .fa-square').css('color', event.color.toString());
    })

    $("input[data-bootstrap-switch]").each(function(){
      $(this).bootstrapSwitch('state', $(this).prop('checked'));
    })

  })
  
</script>

<script>
  // $(document).ready(function () {
  //     $("#searchButton").click(function () {
  //         // Get selected values
  //         var storeId = $("#store_id").val();
  //         var date = $("#date1").val();

  //         // Send AJAX request to fetch data
  //         $.ajax({
  //             type: "POST",
  //             url: "load.php", // Replace with the actual PHP script URL
  //             data: { store_id: storeId, date1: date },
  //             dataType: "json",
  //             success: function (data) {
  //                 // Clear existing table rows
  //                 $("#load_table tbody").empty();

  //                 // Populate the table with fetched data
  //                 $.each(data, function (index, row) {
  //                     var newRow = "<tr><td>" + (index + 1) + "</td><td>" + row.date_updated + "</td><td>" + row.user_name + "</td><td>" + row.cash + "</td><td>" + row.pos + "</td><td>" + row.transfer + "</td><td>" + row.others + "</td><td>" + row.total_amount + "</td></tr>";
  //                     $("#load_table tbody").append(newRow);
  //                 });

  //                 // Update cumulative total
  //                 $("#cumulativeTotal").text(data.cum_sales1);
  //             }
  //         });
  //     });
  // });
</script>