<?php 
// MySQL connection parameters
  $source_host = "localhost";
  $source_username = "root";
  $source_password = "";
  $source_database = "hartsfield_db";

  $dest_host = "localhost";
  $dest_username = "root";
  $dest_password = "";
  $dest_database = "db_mutiple";

  // Connect to source and destination databases
  $source_conn = new mysqli($source_host, $source_username, $source_password, $source_database);
  if ($source_conn->connect_error) {
      die("Connection to source database failed: " . $source_conn->connect_error);
  }

  $dest_conn = new mysqli($dest_host, $dest_username, $dest_password, $dest_database);
  if ($dest_conn->connect_error) {
      die("Connection to destination database failed: " . $dest_conn->connect_error);
  }

  // Check if destination database has any tables
  $check_tables_query = "SHOW TABLES";
  $check_tables_result = $dest_conn->query($check_tables_query);

  if ($check_tables_result->num_rows > 0) {
      // Destination database has tables, proceed with session_start()
      session_start();

      date_default_timezone_set('Africa/Lagos');
      include './private/db_connect.php';

      // Check for Company Setup 
      $query = "SELECT COUNT(*) as total FROM users";
      $result = mysqli_query($conn, $query);
      $row = mysqli_fetch_assoc($result);
      $totalUsers = $row['total'];

      if ($totalUsers <> 0) {
          if(!isset($_SESSION['login_id']))
              header('location:login.php');
          include('./private/header.php');
      } else {
          header('location: sys_setup.php');
      }
  } else {
      // Destination database doesn't have tables, proceed with table creation
      // Retrieve list of tables from source database
      $tables_query = "SHOW TABLES";
      $tables_result = $source_conn->query($tables_query);

      if ($tables_result->num_rows > 0) {
          // Loop through each table
          while ($table_row = $tables_result->fetch_row()) {
              $table_name = $table_row[0];

              // Check if the table name has a prefix of 'vw_'
              if (strpos($table_name, 'vw_') === 0) {
                  // Skip this table and continue to the next one
                  continue;
              }

              // Check if table exists in destination database
              $check_table_query = "SHOW TABLES LIKE '$table_name'";
              $check_table_result = $dest_conn->query($check_table_query);

              if ($check_table_result->num_rows == 0) {
                  // Table doesn't exist in destination, create it
                  $create_table_query = "CREATE TABLE IF NOT EXISTS $dest_database.$table_name LIKE $source_database.$table_name";
                  $dest_conn->query($create_table_query);
              }
          }
      }

      // Insert data into account_type table
      $accountTypes = array(
          array('id' => 1, 'roles' => 'Admin'),
          array('id' => 2, 'roles' => 'Manager'),
          array('id' => 3, 'roles' => 'Cashier'),
          array('id' => 4, 'roles' => 'Supervisor'),
          array('id' => 11, 'roles' => 'Super Admin')
      );

      foreach ($accountTypes as $type) {
          $id = $type['id'];
          $roles = $type['roles'];
          $check_query = "SELECT * FROM account_type WHERE id = $id";
          $check_result = $dest_conn->query($check_query);
          if ($check_result->num_rows == 0) {
              // Record does not exist, perform insertion
              $sql = "INSERT INTO account_type (id, roles) VALUES ('$id', '$roles')";
              if ($dest_conn->query($sql) !== TRUE) {
                  echo "Error: " . $sql . "<br>" . $dest_conn->error;
              }
          }
      }

      // Insert data into pay_mode table
      $payModes = array(
          array('mpay_id' => 1, 'mode_name' => 'Cash'),
          array('mpay_id' => 2, 'mode_name' => 'POS'),
          array('mpay_id' => 3, 'mode_name' => 'Transfer')
      );

      foreach ($payModes as $mode) {
          $mpay_id = $mode['mpay_id'];
          $mode_name = $mode['mode_name'];
          $sql = "INSERT INTO pay_mode (mpay_id, mode_name) VALUES ('$mpay_id', '$mode_name')";

          if ($dest_conn->query($sql) !== TRUE) {
              echo "Error: " . $sql . "<br>" . $dest_conn->error;
          }
      }

      header('location: sys_setup.php');

  }

  // Close connections
  $source_conn->close();
  $dest_conn->close();
?>

 
    <!-- Main Topbar -->
    <?php include './private/topbar.php' ?> 

    <!-- Main Sidebar Container -->
    <?php include './private/sidebar.php' ?>
 
    <section class="content">
      <div class="container-fluid">
         <?php
            $page = isset($_GET['page']) ? $_GET['page'] : 'home';
            if(!file_exists($page.".php")){

                include '404.html';

            }else{

              include $page.'.php';

            }
          ?>
      </div>
    </section>
  
  <!-- Main Modal Load-->
  <div id="preloader"></div>
  <a href="#" class="back-to-top"><i class="icofont-simple-up"></i></a>

	<div class="modal fade" id="confirm_modal" role='dialog'>
		<div class="modal-dialog modal-md" role="document">
		  <div class="modal-content">
			<div class="modal-header">
			<h5 class="modal-title">Confirmation</h5>
		  </div>
		  <div class="modal-body">
			<div id="delete_content"></div>
		  </div>
		  <div class="modal-footer">
			<button type="button" class="btn btn-info" id='confirm' onclick="">Continue</button>
			<button type="button" class="btn btn-warning" data-dismiss="modal">Close</button>
		  </div>
		  </div>
		</div>
	</div>
  <div class="modal fade" id="uni_modal" role='dialog'>
    <div class="modal-dialog modal-md" role="document">
      <div class="modal-content">
        <div class="modal-header">
        <h5 class="modal-title"></h5>
      </div>
      <div class="modal-body">
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-info" id='submit' onclick="$('#uni_modal form').submit()">Save</button>
        <button type="button" class="btn btn-warning" data-dismiss="modal">Cancel</button>
      </div>
      </div>
    </div>
  </div>

  <!-- /.content-wrapper Footer---->
 
    <?php include './private/footer.php' ?> 
 

  <!-- Control Sidebar -->
  <aside class="control-sidebar control-sidebar-dark">
    <!-- Control sidebar content goes here -->
    
  </aside>
  <!-- /.control-sidebar -->

</div>
 
<!-- ./wrapper -->


<script>
	 window.start_load = function(){
    $('body').prepend('<di id="preloader2"></di>')
  }
  window.end_load = function(){
    $('#preloader2').fadeOut('fast', function() {
        $(this).remove();
      })
  }

  window.uni_modal = function($title = '' , $url=''){
    start_load()
    $.ajax({
        url:$url,
        error:err=>{
            console.log()
            alert("An error occured")
        },
        success:function(resp){
            if(resp){
                $('#uni_modal .modal-title').html($title)
                $('#uni_modal .modal-body').html(resp)
                $('#uni_modal').modal('show')
                end_load()
            }
        }
    })
}
window._conf = function($msg='',$func='',$params = []){
     $('#confirm_modal #confirm').attr('onclick',$func+"("+$params.join(',')+")")
     $('#confirm_modal .modal-body').html($msg)
     $('#confirm_modal').modal('show')
  }
   window.alert_toast= function($msg = 'TEST',$bg = 'success'){
      $('#alert_toast').removeClass('bg-success')
      $('#alert_toast').removeClass('bg-danger')
      $('#alert_toast').removeClass('bg-info')
      $('#alert_toast').removeClass('bg-warning')

    if($bg == 'success')
      $('#alert_toast').addClass('bg-success')
    if($bg == 'danger')
      $('#alert_toast').addClass('bg-danger')
    if($bg == 'info')
      $('#alert_toast').addClass('bg-info')
    if($bg == 'warning')
      $('#alert_toast').addClass('bg-warning')
    $('#alert_toast .toast-body').html($msg)
    $('#alert_toast').toast({delay:3000}).toast('show');
  }
  $(document).ready(function(){
    $('#preloader').fadeOut('fast', function() {
        $(this).remove();
      })
  })
</script>	

</body>
</html>