<?php include 'db_connect.php' ?>

<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Onielsoft | ePOS</title>
</head>

<div class="container-fluid">
  <div class="col-lg-12">
    <div class="row">
      <div class="col-md-12">
        <div class="card">
          
          <div class="card-header">
            <h4><b>Profit Summary Sales Report</b>
              <?php if (isset($_POST['filter'])): ?>
                <?php 
                  $startDate = isset($_POST['startDate']) ? $_POST['startDate'] : '';
                  $endDate = isset($_POST['endDate']) ? $_POST['endDate'] : '';

                  if (!empty($startDate) && !empty($endDate)) {
                    // Format the dates for display (optional)
                    $formattedStartDate = date("F j, Y", strtotime($startDate));
                    $formattedEndDate = date("F j, Y", strtotime($endDate));
                    
                    // Display the search period inline with the header
                    echo "<span> - $formattedStartDate to $formattedEndDate</span>";
                  }
                ?>
              <?php endif; ?>
            </h4>
          </div>

          <div class="card-body">

            <form method="POST" action="">
              <div class="row mb-4">
                <?php if ($_SESSION['login_type'] == 1): ?>
                  <div class="col-md-2">
                    <label class="control-label">Store</label>
                    <select name="store_id" id="store_id" class="custom-select browser-default select2">
                      <option value=""></option>
                      <?php 
                        $store = $conn->query("SELECT * FROM stores ORDER BY store_name ASC");
                        while($row = $store->fetch_assoc()):
                      ?>
                      <option value="<?php echo $row['id'] ?>"><?php echo $row['store_name'] ?></option>
                      <?php endwhile; ?>
                    </select>
                  </div>

                  <div class="col-md-3">
                    <label class="control-label">Product</label>
                    <select name="product_id" id="product_id" class="custom-select browser-default select2">
                      <option value=""></option>
                      <?php 
                        $product = $conn->query("SELECT * FROM product_list ORDER BY name ASC");
                        while($row = $product->fetch_assoc()):
                      ?>
                      <option value="<?php echo $row['id'] ?>"><?php echo $row['name'] ?></option>
                      <?php endwhile; ?>
                    </select>
                  </div>

                  <div class="col-md-2">
                    <div class="form-group">
                      <label class="control-label">Start Date</label>
                      <input type="date" class="form-control" id="startDate" name="startDate">
                    </div>
                  </div>
                  
                  <div class="col-md-2">
                    <div class="form-group">
                      <label class="control-label">End Date</label>
                      <input type="date" class="form-control" id="endDate" name="endDate">
                    </div>
                  </div>

                  <div class="col-md-1.5">
                    <label class="control-label">&nbsp</label>
                    <button class="btn btn-block btn-sm btn-info search" type="submit" name="filter" id="filter" value="filter"><i class="fa fa-search"></i> Search</button>
                  </div>
                <?php endif; ?>
              </div>
            </form>

            <?php 
              if (isset($_POST['filter'])) {
                // Get search parameters
                $store_id = isset($_POST['store_id']) ? $_POST['store_id'] : '';
                $product_id = isset($_POST['product_id']) ? $_POST['product_id'] : '';
                $startDate = isset($_POST['startDate']) ? $_POST['startDate'] : '';
                $endDate = isset($_POST['endDate']) ? $_POST['endDate'] : '';

                // Build the SQL query dynamically based on filters
                $sql = "SELECT p.id, p.name,
                        SUM(i.cprice) / COUNT(CASE WHEN i.cprice != 0 THEN i.cprice END) AS avg_cprice,
                        SUM(i.sprice) / COUNT(CASE WHEN i.sprice != 0 THEN i.sprice END) AS avg_sprice,
                        SUM(CASE WHEN i.type = 2 THEN i.qty ELSE 0 END) AS total_qty,
                        COUNT(CASE WHEN i.cprice != 0 THEN i.cprice END) AS cprice_count,
                        COUNT(CASE WHEN i.sprice != 0 THEN i.sprice END) AS sprice_count,
                        (SUM(i.sprice) / COUNT(CASE WHEN i.sprice != 0 THEN i.sprice END) - SUM(i.cprice) / COUNT(CASE WHEN i.cprice != 0 THEN i.cprice END)) * SUM(CASE WHEN i.type = 2 THEN i.qty ELSE 0 END) AS profit
                        FROM product_list p
                        INNER JOIN inventory i ON p.id = i.product_id 
                        WHERE 1=1 ";

                // Add filters if provided
                if (!empty($store_id)) {
                  $sql .= " AND i.store_id = '$store_id' ";
                }

                if (!empty($product_id)) {
                  $sql .= " AND i.product_id = '$product_id' ";
                }

                if (!empty($startDate) && !empty($endDate)) {
                  $sql .= " AND i.date_updated BETWEEN '$startDate 00:00:00' AND '$endDate 23:59:59' ";
                }

                $sql .= "GROUP BY p.id, p.name";

                // Execute query
                $result = $conn->query($sql);

                $totalCostPrice = 0;
                $totalSalesPrice = 0;
                $totalProfit = 0;

                if ($result->num_rows > 0) {
                  // $totalProfit = 0;
            ?>

            <table class="table table-bordered" id="load_table">
              <thead>
                <th class="text-center">#</th>
                <th class="text-left">Product Name</th>
                <th class="text-center">Qty</th>
                <th class="text-center">Avg Cost Price</th>
                <th class="text-center">Avg Selling Price</th>
                <th class="text-center">CPrice Count</th>
                <th class="text-center">SPrice Count</th>
                <th class="text-center">Profit</th>
              </thead>
              <tbody>
                <?php
                  $i = 1;
                  while ($row = $result->fetch_assoc()) {
                    // $totalProfit += $row['profit'];
                    // Calculate the cumulative values
                    $totalProfit += $row['profit'];
                    $totalCostPrice += ($row['avg_cprice'] * $row['total_qty']); // Add cost price * qty
                    $totalSalesPrice += ($row['avg_sprice'] * $row['total_qty']); // Add sales price * qty
            
                ?>
                <tr>
                  <td class="text-center"><?php echo $i++; ?></td>
                  <td class="text-left"><?php echo $row['name']; ?></td>
                  <td class="text-right"><?php echo number_format($row['total_qty'], 1); ?></td>
                  <td class="text-right"><?php echo number_format($row['avg_cprice'], 2); ?></td>
                  <td class="text-right"><?php echo number_format($row['avg_sprice'], 2); ?></td>
                  <td class="text-right"><?php echo $row['cprice_count']; ?></td>
                  <td class="text-right"><?php echo $row['sprice_count']; ?></td>
                  <td class="text-right"><?php echo number_format($row['profit'], 2); ?></td>
                </tr>
                <?php } ?>
              </tbody>
              <tfoot>
                <tr>
                    <td class="text-right" colspan="7">Cumulative Cost Price</td>
                    <td class="text-right"><?php echo "&#8358; ".number_format($totalCostPrice, 2); ?></td>
                </tr>
                <tr>
                    <td class="text-right" colspan="7">Cumulative Sales Price</td>
                    <td class="text-right"><?php echo "&#8358; ".number_format($totalSalesPrice, 2); ?></td>
                </tr>
                <tr>
                    <td class="text-right" colspan="7">Cumulative Profit</td>
                    <td class="text-right"><?php echo "&#8358; ".number_format($totalProfit, 2); ?></td>
                </tr>
              </tfoot>
            </table>

            <?php 
                } else {
                  echo "No results found";
                }
              }
            ?>

          </div>
        </div>
      </div>
    </div>
  </div>
</div>

  <script>
      $(function () {
        $("#load_table").DataTable({
          "responsive": true, "lengthChange": false, "autoWidth": false,
          "buttons": ["copy", "csv", "excel", "pdf", "print", "colvis"]
        }).buttons().container().appendTo('#load_table_wrapper .col-md-6:eq(0)');
        $('#example2').DataTable({
          "paging": true,
          "lengthChange": false,
          "searching": false,
          "ordering": true,
          "info": true,
          "autoWidth": false,
          "responsive": true,
        });
      });
  </script> 

</html>