<?php 
	include('./private/db_connect.php');
	
	if (isset($_POST['submit'])) {
		// Get the values of product_id, store_id, and qty from your form or variables
		$product_id = $_POST['product_id'];
		$store_id = $_POST['store_id'];
		$qty = $_POST['qty'];
		$action_type = $_POST['action_type'];
		$remarks = $_POST['remarks'];
		$user_id = $_POST['user_id'];

		if ($qty == "" || $store_id == "" || $product_id == "") {
			echo '<script>alert("Some important record(s) is empty")</script>';
		} else {
			//if ($action_type !== 'Returned') {
				// Create a prepared statement with placeholders
				$insert_query = "INSERT INTO damaged_product (product_id, store_id, qty, user_id, action_type, remarks) VALUES (?, ?, ?, ?, ?, ?)";
				$stmt = $conn->prepare($insert_query);
				// Bind the parameters to the placeholders
				$stmt->bind_param("iiisss", $product_id, $store_id, $qty, $user_id, $action_type, $remarks);
				if ($stmt->execute()) {
					echo '<script>alert("Record saved successfully")</script>';
				} else {
					echo '<script>alert("Record failed to save: ' . $conn->error . '")</script>';
				}
			//}

			// Check if the product_id and store_id combination already exists in the main_store table
			$sql = "SELECT * FROM main_store WHERE product_id = $product_id AND store_id = $store_id";
			$result = mysqli_query($conn, $sql);

			if (mysqli_num_rows($result) > 0) {
				$row = mysqli_fetch_assoc($result);
				$existing_damaged = $row['total_damaged'];
				$existing_sales = $row['total_sales'];

				if ($action_type === 'Damaged' || $action_type === 'Expired') {
					$new_damaged_qty = $existing_damaged + $qty;
					$update_query = "UPDATE main_store SET total_damaged = $new_damaged_qty WHERE product_id = $product_id AND store_id = $store_id";
				} elseif ($action_type === 'Returned') {
					$new_sales_qty = $existing_sales - $qty;
					$update_query = "UPDATE main_store SET total_sales = $new_sales_qty WHERE product_id = $product_id AND store_id = $store_id";
				}

				if (isset($update_query) && !empty($update_query)) {
					if ($conn->query($update_query) === TRUE) {
						// echo '<script>alert("Record Updated successfully")</script>';
					} else {
						echo '<script>alert("Record failed to update")</script>';
					}
				}
			} else {
				// Handle the case where the combination doesn't exist in main_store
			}
		}
	}
?>


<div class="wrapper">
<div class="content-wrapper">
	<div class="container-fluid">

		<div class="content-header">
		<div class="container-fluid">
			<div class="row mb-2">
			<div class="col-sm-6">
				<h1 class="m-0">Onielsoft | Martvet</h1>
			</div><!-- /.col -->
			<div class="col-sm-6">
				<ol class="breadcrumb float-sm-right">
				<li class="breadcrumb-item"><a href="index.php">Home</a></li>
				<li class="breadcrumb-item active">Stock Management</li>
				</ol>
			</div><!-- /.col -->
			</div><!-- /.row -->
		</div><!-- /.container-fluid -->
		</div>

	<div class="col-lg-12">
		<div class="card card-outline card-warning">
			<div class="card-header">
				<h2 class="card-title"><b>Manage Returned | Damaged | Expied Product</b></h2>

				<div class="card-tools">
				<button type="button" class="btn btn-tool" data-card-widget="collapse">
					<i class="fas fa-minus"></i>
				</button>
				<button type="button" class="btn btn-tool" data-card-widget="remove">
					<i class="fas fa-times"></i>
				</button>
				</div>
			</div>
			<div class="card-body">
				<!-- <form action="" id="manage-purchase"> -->
					<div class="col-md-12">
						<form action="" id="manage-rde" method="POST">
                            <div class="row mb-3">
								<div class="form-group col-md-2">
									<div class="form-group">
									  <label>Action Type</label>
									  <select name="action_type" id="action_type" class="form-control select2 select2-danger" data-dropdown-css-class="select2-danger" style="width: 100%;">
										<option value="0" selected="">Select Action</option>
										<option value="Returned">Returned</option>
										<option value="Damaged">Damaged</option>
										<option value="Expired">Expired</option>
									  </select>
									</div>
								</div>

                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label class="control-label">Barcode/ Product</label>
                                        <select name="product_id" id="product_id" class="custom-select browser-default select2" data-placeholder="Select Product..." style="width: 100%;">
                                            <option value=""></option>
                                        <?php 
                                        $cat = $conn->query("SELECT * FROM category_list order by name asc");
                                            while($row=$cat->fetch_assoc()):
                                                $cat_arr[$row['id']] = $row['name'];
                                            endwhile;
                                        $product = $conn->query("SELECT * FROM product_list WHERE store_id = '".$_SESSION['login_store_id']."'  ORDER BY name asc");
                                        while($row=$product->fetch_assoc()):
                                            $prod[$row['id']] = $row;
                                        ?>
                                            <option value="<?php echo $row['id'] ?>" data-name="<?php echo $row['name'] ?>" data-description="<?php echo $row['description'] ?>"><?php echo $row['name'] . ' | ' . $row['sku'] ?></option>
                                        <?php endwhile; ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-1">
									<input type="hidden" name="user_id" value="<?php echo ($_SESSION['login_id']) ?>">
									<input type="hidden" id="store_id" name="store_id" value="<?php echo ($_SESSION['login_store_id']) ?>">
                                    <label class="control-label">Qty</label>
                                    <input type="number" min="1" class="form-control form-control-sm text-right" step="any" name="qty" id="qty" >
                                </div>
                            </div>
                            <div class="row mb-3">
                                <div class="col-md-3">
                                    <label class="control-label">Remarks</label>
                                    <input type="text" class="form-control form-control-sm text-left" name="remarks" id="remarks" >
                                </div>
                                <div class="col-md-2">
                                    <label class="control-label">&nbsp</label>
                                    <button class="btn btn-block btn-sm btn-info" type="submit" name="submit"><i class="fa fa-save"></i> Save</button>
                                </div>
                            </div>
						</form>
						<hr>
						<div class="col-md-12">	
							<table class="table table-bordered" id="load_table" style="font-size: 10px;">
								<colgroup>
									<col width="4%">
									<col width="10%">
									<col width="10%">
									<col width="20%">
									<col width="4%">
									<col width="12%">
									<col width="20%">
									<col width="10%">
                                    <col width="10%">
								<thead>
									<tr>
										<th class="text-left">#</th>
										<th class="text-left">Store</th>
										<th class="text-left">Barcode</th>
										<th class="text-left">Product</th>
										<th class="text-center">Qty</th>
										<th class="text-left">Action</th>
										<th class="text-left">Remarks</th>
										<th class="text-right">Date</th>
                                        <th class="text-right">Actioned By</th>
									</tr>
								</thead>
								<tbody>
									<?php 
										$i = 1;
									 	$sql = $conn->query("SELECT *, stores.store_name, product_list.name, product_list.sku, users.names
										 	FROM damaged_product
                                            INNER JOIN stores ON damaged_product.store_id = stores.id
                                            INNER JOIN product_list ON damaged_product.product_id = product_list.id
                                            INNER JOIN users ON damaged_product.user_id = users.id
											WHERE user_id = '".$_SESSION['login_id']."'
									 	 	ORDER BY date_updated DESC LIMIT 5000");
										while($row=$sql->fetch_assoc()):
									?>
										<tr class="item-row">
											<td class="text-center"><?php echo $i++ ?></td>
                                            <td class="text-left"><?php echo $row['store_name']; ?></td>
                                            <td class="text-left"><?php echo $row['sku']; ?></td>
                                            <td class="text-left"><?php echo $row['name']; ?></td>
                                            <td class="text-center"><?php echo $row['qty']; ?></td>
                                            <td class="text-left"><?php echo $row['action_type']; ?></td>
											<td class="text-left"><?php echo $row['remarks']; ?></td>
                                            <td class="text-right"><?php echo $row['date_updated']; ?></td>
                                            <td class="text-right"><?php echo $row['names']; ?></td> 
										</tr>
									<?php endwhile; ?>
								</tbody>
							</table>
						</div>
					</div>
			</div> 
		</div>
		</div>
	</div>
</div>

<style type="text/css">
	#tr_clone{
		display: none;
	}
	td{
		vertical-align: middle;
	}
	td p {
		margin: unset;
	}
	td input[type='number']{
		height: calc(100%);
		width: calc(100%);

	}
	input[type=number]::-webkit-inner-spin-button, 
	input[type=number]::-webkit-outer-spin-button { 
	  -webkit-appearance: none; 
	  margin: 0; 
	}
</style>


<script type="text/javascript" src="https://cdn.datatables.net/buttons/1.6.5/js/dataTables.buttons.min.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/buttons/1.6.5/js/buttons.print.min.js"></script>
<!-- jQuery -->
<script src="./plugins/jquery/jquery.min.js"></script>
<!-- Bootstrap 4 -->
<script src="./plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
<!-- DataTables  & Plugins -->
<script src="./plugins/datatables/jquery.dataTables.min.js"></script>
<script src="./plugins/datatables-bs4/js/dataTables.bootstrap4.min.js"></script>
<script src="./plugins/select2/js/select2.full.min.js"></script>
<script src="./plugins/datatables-responsive/js/dataTables.responsive.min.js"></script>
<script src="./plugins/datatables-responsive/js/responsive.bootstrap4.min.js"></script>
<script src="./plugins/datatables-buttons/js/dataTables.buttons.min.js"></script>
<script src="./plugins/datatables-buttons/js/buttons.bootstrap4.min.js"></script>
<script src="./plugins/jszip/jszip.min.js"></script>
<script src="./plugins/pdfmake/pdfmake.min.js"></script>
<script src="./plugins/pdfmake/vfs_fonts.js"></script>
<script src="./plugins/datatables-buttons/js/buttons.html5.min.js"></script>
<script src="./plugins/datatables-buttons/js/buttons.print.min.js"></script>
<script src="./plugins/datatables-buttons/js/buttons.colVis.min.js"></script>



<script>
  $(function () {
    //Initialize Select2 Elements
    $('.select2').select2()

    //Initialize Select2 Elements
    $('.select2bs4').select2({
      theme: 'bootstrap4'
    })

    //Datemask dd/mm/yyyy
    $('#datemask').inputmask('dd/mm/yyyy', { 'placeholder': 'dd/mm/yyyy' })
    //Datemask2 mm/dd/yyyy
    $('#datemask2').inputmask('mm/dd/yyyy', { 'placeholder': 'mm/dd/yyyy' })
    //Money Euro
    $('[data-mask]').inputmask()

    //Date picker
    $('#reservationdate').datetimepicker({
        format: 'MM/DD/YYYY'
    });

	$('#reservationdate1').datetimepicker({
		format: 'MM/DD/YYYY'
        // format: 'L'
    });

    //Date and time picker
    $('#reservationdatetime').datetimepicker({ icons: { time: 'far fa-clock' } });

    //Date range picker
    $('#reservation').daterangepicker()
    //Date range picker with time picker
    $('#reservationtime').daterangepicker({
      timePicker: true,
      timePickerIncrement: 30,
      locale: {
        format: 'MM/DD/YYYY hh:mm A'
      }
    })
    //Date range as a button
    $('#daterange-btn').daterangepicker(
      {
        ranges   : {
          'Today'       : [moment(), moment()],
          'Yesterday'   : [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
          'Last 7 Days' : [moment().subtract(6, 'days'), moment()],
          'Last 30 Days': [moment().subtract(29, 'days'), moment()],
          'This Month'  : [moment().startOf('month'), moment().endOf('month')],
          'Last Month'  : [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
        },
        startDate: moment().subtract(29, 'days'),
        endDate  : moment()
      },
      function (start, end) {
        $('#reportrange span').html(start.format('MMMM D, YYYY') + ' - ' + end.format('MMMM D, YYYY'))
      }
    )

    //Timepicker
    $('#timepicker').datetimepicker({
      format: 'LT'
    })

    //Bootstrap Duallistbox
    $('.duallistbox').bootstrapDualListbox()

    //Colorpicker
    $('.my-colorpicker1').colorpicker()
    //color picker with addon
    $('.my-colorpicker2').colorpicker()

    $('.my-colorpicker2').on('colorpickerChange', function(event) {
      $('.my-colorpicker2 .fa-square').css('color', event.color.toString());
    })

    $("input[data-bootstrap-switch]").each(function(){
      $(this).bootstrapSwitch('state', $(this).prop('checked'));
    })

  })
  // BS-Stepper Init
  document.addEventListener('DOMContentLoaded', function () {
    window.stepper = new Stepper(document.querySelector('.bs-stepper'))
  })

  // DropzoneJS Demo Code Start
  Dropzone.autoDiscover = false

  // Get the template HTML and remove it from the doumenthe template HTML and remove it from the doument
  var previewNode = document.querySelector("#template")
  previewNode.id = ""
  var previewTemplate = previewNode.parentNode.innerHTML
  previewNode.parentNode.removeChild(previewNode)

  var myDropzone = new Dropzone(document.body, { // Make the whole body a dropzone
    url: "/target-url", // Set the url
    thumbnailWidth: 80,
    thumbnailHeight: 80,
    parallelUploads: 20,
    previewTemplate: previewTemplate,
    autoQueue: false, // Make sure the files aren't queued until manually added
    previewsContainer: "#previews", // Define the container to display the previews
    clickable: ".fileinput-button" // Define the element that should be used as click trigger to select files.
  })

</script>

<script>
    
  $(function () {
    $("#load_table").DataTable({
      "responsive": true, "lengthChange": true, "autoWidth": false, "info": true,"ordering": true, "paging": true, "searching": true,
      "buttons": ["copy", "csv", "excel", "pdf", "print", "colvis"]
    }).buttons().container().appendTo('#load_table_wrapper .col-md-6:eq(0)');
   
  });
</script>

<script>
	$('#manage-purchasess').submit(function(e){
		e.preventDefault()
		start_load()
		$.ajax({
			url:'ajax.php?action=save_purchasess',
			data: new FormData($(this)[0]),
		    cache: false,
		    contentType: false,
		    processData: false,
		    method: 'POST',
		    type: 'POST',
			success:function(resp){
				if(resp==1){
					alert_toast("Data successfully added",'success')
					setTimeout(function(){
						location.reload()
					},1500)

				}
				else if(resp==2){
					alert_toast("Data successfully updated",'success')
					setTimeout(function(){
						location.reload()
					},1500)

				}
			}
		})
	})
</script>