<!DOCTYPE html>
<html>
<head>
    <title>Barcode Generator</title>
</head>
<body>
    <form id="barcode-form">
        <label for="random-code">Random Code:</label>
        <input type="text" id="random-code" name="random-code" readonly>
        <button type="button" onclick="generateBarcode()">Generate Barcode</button>
        <button type="button" onclick="printBarcode()">Print Barcode</button>
    </form>
	<br/>
    <div id="barcode-container">
	<p id="generated-code"></p>
	</div>
	<div id="barcode-container2">
		<!-- Barcode image will be displayed here 
		<img id="barcode-image" src="" alt="Barcode">-->
		<!-- Display the generated code below the barcode -->
		<p id="generated-code"></p>
	</div>

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script>
        function generateRandomCode() {
            const codeLength = 6;
            const randomCode = Math.floor(Math.random() * Math.pow(10, codeLength)).toString();
            const paddedCode = randomCode.padStart(codeLength, '0');
            return paddedCode;
        }
		
		// function generateBarcode() {
            // const randomCode = generateRandomCode();
            // $('#random-code').val(randomCode);
            // $.post('generateBarcode.php', { code: randomCode }, function(data) {
                // // Display the barcode image
                // $('#barcode-image').attr('src', 'data:image/png;base64,' + data);

                // // Display the generated code below the barcode
                // $('#generated-code').text(randomCode);
            // });
        // }

        function generateBarcode() {
            const randomCode = generateRandomCode();
            $('#random-code').val(randomCode);
            $.post('generateBarcode.php', { code: randomCode }, function(data) {
                $('#barcode-container').html(data);
				$('#generated-code').text(randomCode);
            });
        }

        function printBarcode() {
            // Assuming that the barcode is displayed in an element with the ID "barcode-container"
            const barcodeContainer = document.getElementById('barcode-container');

            // Create a new window with the barcode to print
            const printWindow = window.open('', '', 'width=600,height=400');
            printWindow.document.open();
            printWindow.document.write('<html><head><title>Print Barcode</title></head><body>');
            printWindow.document.write('<img src="' + barcodeContainer.innerHTML + '">');
            printWindow.document.write('</body></html>');
            printWindow.document.close();

            // Initiate the print dialog for the new window
            printWindow.print();
            printWindow.close();
        }
    </script>
</body>
</html>