<!DOCTYPE html>
<html>
<head>
    <title>Barcode Generator</title>
</head>
<body>
    <form id="barcode-form">
        <label for="random-code">Random Code:</label>
        <input type="text" id="random-code" name="random-code" readonly>
        <button type="button" onclick="generateBarcode()">Generate Barcode</button>
    </form>
	<br></br>
    <div id="barcode-container"></div>

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script>
		function generateRandomCode() {
			// Define the length of the numeric code
			const codeLength = 8;
			
			// Generate a random numeric code
			const randomCode = Math.floor(Math.random() * Math.pow(10, codeLength)).toString();
			
			// Ensure the code has the desired length by padding with leading zeros if needed
			const paddedCode = randomCode.padStart(codeLength, '0');
			
			return paddedCode;
		}

        function generateRandomCode22() {
            // Generate a random code (you can customize this)
            const randomCode = Math.random().toString(36).substr(2, 8);
            return randomCode;
        }

        function generateBarcode() {
            const randomCode = generateRandomCode();
            $('#random-code').val(randomCode);

            // Send the code to PHP to generate the barcode
            $.post('generateBarcode.php', { code: randomCode }, function(data) {
                $('#barcode-container').html(data);
            });
        }
    </script>
</body>
</html>