<?php
include 'includes/db_connect.php';

try {
    // 1. Settings Table to store configuration like TOTAL_TICKETS
    // setting_key will be the unique identifier (e.g., 'total_tickets')
    $sql = "CREATE TABLE IF NOT EXISTS `settings` (
        `id` INT(11) AUTO_INCREMENT PRIMARY KEY,
        `setting_key` VARCHAR(50) NOT NULL UNIQUE,
        `setting_value` VARCHAR(255) NOT NULL,
        `updated_at` DATETIME DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4";
    $pdo->exec($sql);
    echo "Settings table created.<br>";

    // 2. Insert Default Ticket Limit (800)
    // Using INSERT IGNORE so we don't overwrite if it already exists (though ON DUPLICATE KEY UPDATE might be better to reset, here we just want to ensure it exists)
    $stmt = $pdo->prepare("INSERT IGNORE INTO `settings` (`setting_key`, `setting_value`) VALUES ('total_tickets', '800')");
    $stmt->execute();
    echo "Default ticket limit set to 800.<br>";

} catch (PDOException $e) {
    echo "Error updating database: " . $e->getMessage();
}
?>
