<?php
include 'includes/db_connect.php';

if (!isset($_GET['ref'])) {
    die("Invalid request.");
}

$booking_ref = htmlspecialchars($_GET['ref']);

// Fetch Booking & Tickets
$stmt = $pdo->prepare("SELECT * FROM bookings WHERE booking_ref = ?");
$stmt->execute([$booking_ref]);
$booking = $stmt->fetch();

if (!$booking) {
    die("Booking not found.");
}

$stmt = $pdo->prepare("SELECT * FROM tickets WHERE booking_id = ?");
$stmt->execute([$booking['id']]);
$tickets = $stmt->fetchAll();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Booking Confirmed - Calabar Day 2026</title>
    <link rel="stylesheet" href="../assets/css/style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        .ticket-container {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
            gap: 20px;
            margin-top: 30px;
        }
        .digital-ticket {
            background: #fff;
            color: #333;
            border-radius: 10px;
            overflow: hidden;
            box-shadow: 0 5px 15px rgba(0,0,0,0.2);
            position: relative;
        }
        .ticket-header {
            background: var(--primary-color);
            color: var(--secondary-color);
            padding: 15px;
            text-align: center;
            font-family: 'Cinzel', serif;
        }
        .ticket-body {
            padding: 20px;
        }
        .qr-code {
            text-align: center;
            margin-top: 15px;
        }
        .ticket-info {
            display: flex;
            justify-content: space-between;
            margin-bottom: 5px;
            font-size: 0.9rem;
        }
        .ticket-label {
            font-weight: bold;
            color: #555;
        }
        @media print {
            body { background: #fff !important; color: #000; }
            header, footer, .btn-primary, .hero h1, .hero p, .hero i { display: none !important; } /* Hide navigation, buttons, and success message text if only tickets are needed, or keep text? User said "print only the tickets". Let's hide the success message wrapper styling but keep ticket content */
            
            /* Actually, let's keep it simple: Hide everything, then show tickets */
            body * {
                visibility: hidden;
            }
            .ticket-container, .ticket-container * {
                visibility: visible;
            }
            .ticket-container {
                position: absolute;
                left: 0;
                top: 0;
                width: 100%;
                display: block;
            }
            
            /* Reset backgrounds */
            .hero, .hero > .container > div {
                background: none !important;
                box-shadow: none !important;
                border: none !important;
            }
            
            .digital-ticket { 
                border: 1px solid #000; 
                page-break-inside: avoid; 
                margin-bottom: 20px; 
                box-shadow: none;
                color: #000;
            }
            .ticket-header {
                background: #eee !important; /* Light grey for header in print */
                color: #000 !important; /* Black text */
                border-bottom: 1px solid #000;
            }
            .ticket-label { color: #000; }
            .ticket-body { color: #000; }
        }
    </style>
</head>
<body>

    <header>
        <div class="container nav-content">
            <nav>
                <a href="../" class="logo">CALABAR<span style="color: #fff;">DAY</span></a>
            </nav>
        </div>
    </header>

    <section class="hero" style="height: auto; min-height: 100vh; padding-top: 120px;">
        <div class="container">
            <div style="background: rgba(0,0,0,0.5); padding: 40px; border-radius: 20px; border: 1px solid rgba(255,255,255,0.1);">
                <i class="fas fa-check-circle" style="font-size: 4rem; color: #4CAF50; margin-bottom: 20px;"></i>
                <h1 style="font-size: 2.5rem;">Booking Confirmed!</h1>
                <p>Thank you, <?php echo htmlspecialchars($booking['full_name']); ?>. Your tickets have been sent to <strong><?php echo htmlspecialchars($booking['email']); ?></strong>.</p>
                <p>Booking Reference: <span style="color: var(--secondary-color); font-weight: bold;"><?php echo $booking_ref; ?></span></p>
                
                <div class="ticket-container">
                    <?php foreach ($tickets as $ticket): ?>
                        <div class="digital-ticket">
                            <div class="ticket-header">
                                <h3>CALABAR DAY 2026</h3>
                                <p>August 15, 2026 | 3:00 PM</p>
                            </div>
                            <div class="ticket-body">
                                <div class="ticket-info">
                                    <span class="ticket-label">Type:</span>
                                    <span><?php echo htmlspecialchars($ticket['ticket_type']); ?></span>
                                </div>
                                <div class="ticket-info">
                                    <span class="ticket-label">Venue:</span>
                                    <span>City Pavilion, RM5 2BH</span>
                                </div>
                                <div class="ticket-info">
                                    <span class="ticket-label">Ticket ID:</span>
                                    <span style="font-family: 'Courier New', monospace; font-weight: bold; font-size: 1.1rem;"><?php echo htmlspecialchars($ticket['ticket_code']); ?></span>
                                </div>
                                <div class="qr-code">
                                    <!-- Using Google Charts API for QR Code (Deprecated but still works usually) or goqr.me -->
                                    <img src="https://api.qrserver.com/v1/create-qr-code/?size=150x150&data=<?php echo $ticket['ticket_code']; ?>" alt="QR Code">
                                </div>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>

                <div style="margin-top: 40px;">
                    <button onclick="window.print()" class="btn-primary"><i class="fas fa-print"></i> Print / Save as PDF</button>
                    <a href="../" class="btn-primary" style="margin-left: 20px;">Back to Home</a>
                </div>
            </div>
        </div>
    </section>

    <footer>
        <div class="container">
            <p>&copy; 2026 Calabar Community UK.</p>
        </div>
    </footer>

</body>
</html>
