<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

include 'includes/db_connect.php';

try {
    // 1. Users Table (Admin)
    $sql = "CREATE TABLE IF NOT EXISTS `users` (
        `id` INT(11) AUTO_INCREMENT PRIMARY KEY,
        `username` VARCHAR(50) NOT NULL UNIQUE,
        `password` VARCHAR(255) NOT NULL,
        `role` ENUM('admin', 'staff') DEFAULT 'admin',
        `created_at` DATETIME DEFAULT CURRENT_TIMESTAMP
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4";
    $pdo->exec($sql);
    echo "Users table created successfully.\n";

    // Add default admin (Password: Admin@123)
    $adminUser = 'Admin';
    $passwordHash = password_hash('Admin@123', PASSWORD_DEFAULT);
    
    // Check if user exists
    $stmt = $pdo->prepare("SELECT COUNT(*) FROM `users` WHERE `username` = ?");
    $stmt->execute([$adminUser]);
    if ($stmt->fetchColumn() == 0) {
        $stmt = $pdo->prepare("INSERT INTO `users` (`username`, `password`, `role`) VALUES (?, ?, 'admin')");
        $stmt->execute([$adminUser, $passwordHash]);
        echo "Default admin user added.\n";
    } else {
        echo "Default admin user already exists.\n";
    }

    // 2. Bookings Table
    $sql = "CREATE TABLE IF NOT EXISTS `bookings` (
        `id` INT(11) AUTO_INCREMENT PRIMARY KEY,
        `booking_ref` VARCHAR(20) NOT NULL UNIQUE,
        `full_name` VARCHAR(100) NOT NULL,
        `email` VARCHAR(100) NOT NULL,
        `phone` VARCHAR(20) NOT NULL,
        `address` TEXT,
        `date_created` DATETIME DEFAULT CURRENT_TIMESTAMP,
        `total_amount` DECIMAL(10, 2) NOT NULL,
        `payment_status` ENUM('pending', 'paid', 'failed') DEFAULT 'pending',
        `stripe_payment_id` VARCHAR(255) NULL
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4";
    $pdo->exec($sql);
    echo "Bookings table created successfully.\n";

    // 3. Tickets (Individual Tickets generated)
    $sql = "CREATE TABLE IF NOT EXISTS `tickets` (
        `id` INT(11) AUTO_INCREMENT PRIMARY KEY,
        `booking_id` INT(11) NOT NULL,
        `ticket_code` VARCHAR(50) NOT NULL UNIQUE,
        `ticket_type` VARCHAR(50) NOT NULL,
        `price` DECIMAL(10, 2) NOT NULL,
        `status` ENUM('valid', 'used', 'cancelled') DEFAULT 'valid',
        `scanned_at` DATETIME NULL,
        FOREIGN KEY (`booking_id`) REFERENCES `bookings`(`id`) ON DELETE CASCADE
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4";
    $pdo->exec($sql);
    echo "Tickets table created successfully.\n";

    echo "Database structure setup complete.\n";

} catch(PDOException $e) {
    echo "Error setting up database: " . $e->getMessage();
}
?>
