<?php
session_start();
include 'includes/db_connect.php';

$booking_ref = '';

if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['booking_ref'])) {
    $booking_ref = htmlspecialchars($_POST['booking_ref']);
} elseif (isset($_GET['ref']) && isset($_GET['internal_redirect'])) {
    $booking_ref = htmlspecialchars($_GET['ref']);
} else {
    die("Invalid request.");
}

try {
    $pdo->beginTransaction();

    // Validate booking exists
    $stmt = $pdo->prepare("SELECT * FROM bookings WHERE booking_ref = ?");
    $stmt->execute([$booking_ref]);
    $booking = $stmt->fetch();

    if (!$booking) {
        die("Booking not found.");
    }

    // If coming from Payment Gateway (POST), update status
    if ($_SERVER["REQUEST_METHOD"] == "POST") {
        $stmt = $pdo->prepare("UPDATE bookings SET payment_status = 'paid', stripe_payment_id = ? WHERE id = ?");
        $stmt->execute(['test_txn_' . uniqid(), $booking['id']]);
    }

    // Check if tickets already exist
    $checkTickets = $pdo->prepare("SELECT count(*) FROM tickets WHERE booking_id = ?");
    $checkTickets->execute([$booking['id']]);

    if ($checkTickets->fetchColumn() == 0) {
        // Fetch items
        $stmtItems = $pdo->prepare("SELECT * FROM booking_items WHERE booking_id = ?");
        $stmtItems->execute([$booking['id']]);
        $items = $stmtItems->fetchAll();

        $ticketStmt = $pdo->prepare("INSERT INTO tickets (booking_id, ticket_code, ticket_type, price, status) VALUES (?, ?, ?, ?, 'valid')");

        foreach ($items as $item) {
            for ($i = 0; $i < $item['quantity']; $i++) {
                // Generate Unique Ticket Code: REF-TYPE-RAND
                $shortType = strtoupper(substr($item['ticket_type'], 0, 1));
                $ticketCode = $booking['booking_ref'] . '-' . $shortType . '-' . strtoupper(bin2hex(random_bytes(3)));
                
                $ticketStmt->execute([$booking['id'], $ticketCode, $item['ticket_type'], $item['price']]);
            }
        }
    }
    
    $pdo->commit();
    header("Location: ../../ticket/confirmed?ref=$booking_ref");
    exit();

} catch (Exception $e) {
    $pdo->rollBack();
    die("Error confirming payment: " . $e->getMessage());
}
?>
