<?php
session_start();
include 'includes/db_connect.php';

if (!isset($_GET['ref']) || !isset($_GET['amount'])) {
    die("Invalid request.");
}

$ref = htmlspecialchars($_GET['ref']);
$amount = htmlspecialchars($_GET['amount']);

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Secure Payment - Calabar Day 2026</title>
    <link rel="stylesheet" href="../../assets/css/style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        body { background: #1a0b2e; font-family: 'Montserrat', sans-serif; display: flex; justify-content: center; align-items: center; min-height: 100vh; background-image: radial-gradient(circle at 50% 50%, #2c154a 0%, #1a0b2e 100%); }
        
        .payment-box { 
            background: rgba(255, 255, 255, 0.95); 
            padding: 50px 40px; 
            border-radius: 20px; 
            box-shadow: 0 20px 60px rgba(0,0,0,0.5); 
            width: 100%; 
            max-width: 480px; 
            border: 1px solid rgba(255,255,255,0.1);
            position: relative;
            overflow: hidden;
        }
        
        /* Gold stripe at top */
        .payment-box::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 6px;
            background: linear-gradient(90deg, #d4af37, #f9d976);
        }

        .stripe-header { 
            display: flex; 
            align-items: center; 
            justify-content: space-between;
            margin-bottom: 30px; 
            padding-bottom: 20px;
            border-bottom: 1px solid #eee; 
        }
        
        .stripe-logo { 
            font-size: 26px; 
            font-weight: 800; 
            color: #5469d4; 
            letter-spacing: -1px;
        } 
        
        h3 {
            font-family: 'Cinzel', serif;
            color: #1a0b2e;
            font-size: 1.5rem;
            margin-bottom: 5px;
            text-align: center;
        }

        p {
            color: #666;
            margin-bottom: 25px;
            text-align: center;
            font-size: 0.95rem;
        }
        
        .amount-display { 
            font-size: 3rem; 
            font-weight: 700; 
            margin: 10px 0 30px; 
            color: #1a0b2e; 
            text-align: center;
            font-family: 'Cinzel', serif;
        }
        
        .form-label {
            display: block; 
            margin-bottom: 8px; 
            font-weight: 600; 
            font-size: 0.85rem; 
            color: #444; 
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }

        .form-input {
            width: 100%; 
            padding: 14px; 
            border: 1px solid #e0e0e0; 
            border-radius: 8px; 
            background: #f9f9f9;
            font-size: 1rem;
            color: #333;
            transition: all 0.3s ease;
        }
        
        .form-input:focus {
            outline: none;
            border-color: #5469d4;
            background: #fff;
            box-shadow: 0 0 0 3px rgba(84, 105, 212, 0.1);
        }

        .btn-pay { 
            background: #5469d4; 
            color: white; 
            border: none; 
            padding: 16px; 
            width: 100%; 
            border-radius: 8px; 
            font-size: 16px; 
            font-weight: 600; 
            cursor: pointer; 
            transition: all 0.3s ease; 
            margin-top: 10px;
            box-shadow: 0 4px 12px rgba(84, 105, 212, 0.3);
        }
        
        .btn-pay:hover { 
            background: #4355b9; 
            transform: translateY(-1px);
            box-shadow: 0 6px 15px rgba(84, 105, 212, 0.4);
        }
        
        .secure-badge { 
            text-align: center; 
            margin-top: 25px; 
            font-size: 0.8rem; 
            color: #888; 
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 8px;
        }
    </style>
</head>
<body>

<div class="payment-box">
    <div class="stripe-header">
        <span class="stripe-logo">Stripe</span>
        <span style="font-size: 12px; color: #888; margin-left: auto;">Test Mode</span>
    </div>
    
    <h3>Calabar Day 2026 Ticket Purchase</h3>
    <p>Complete your payment securely.</p>
    
    <div class="amount-display">£<?php echo number_format($amount, 2); ?></div>
    
    <form action="../../secure/verify/payment" method="POST">
        <input type="hidden" name="booking_ref" value="<?php echo $ref; ?>">
        <input type="hidden" name="payment_method" value="stripe_test">
        
        <div style="margin-bottom: 20px;">
            <label class="form-label">Card Number</label>
            <div style="position: relative;">
                <input type="text" class="form-input" placeholder="0000 0000 0000 0000" disabled value="4242 4242 4242 4242" style="padding-left: 45px;">
                <i class="fas fa-credit-card" style="position: absolute; left: 15px; top: 50%; transform: translateY(-50%); color: #888;"></i>
            </div>
        </div>
        
        <div style="display: flex; gap: 20px; margin-bottom: 25px;">
            <div style="flex: 1;">
                <label class="form-label">Expiry</label>
                <input type="text" class="form-input" placeholder="MM / YY" disabled value="12 / 28">
            </div>
            <div style="flex: 1;">
                <label class="form-label">CVC</label>
                <div style="position: relative;">
                    <input type="text" class="form-input" placeholder="123" disabled value="123" style="padding-left: 40px;">
                    <i class="fas fa-lock" style="position: absolute; left: 15px; top: 50%; transform: translateY(-50%); color: #888; font-size: 0.8rem;"></i>
                </div>
            </div>
        </div>
        
        <button type="submit" class="btn-pay">Pay £<?php echo number_format($amount, 2); ?></button>
    </form>
    
    <div class="secure-badge">
        <i class="fas fa-lock"></i> 128-bit SSL Encrypted Payment
    </div>
</div>

</body>
</html>
