<?php
session_start();
// Generate CSRF Token for security
if (empty($_SESSION['csrf_token'])) {
    $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Calabar Day 2026 - Event Booking</title>
    <!-- Fonts & Icons -->
    <link rel="stylesheet" href="assets/css/style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <!-- Meta -->
    <meta name="description" content="Join us for Calabar Day 2026. A celebration of culture, community, and fundraising for the Calabar Community House UK.">
</head>
<body>

    <!-- Navigation -->
    <header id="navbar">
        <div class="container nav-content">
            <nav>
                <a href="#" class="logo">CALABAR<span style="color: #fff;">DAY</span></a>
                <ul class="nav-links">
                    <li><a href="#home">Home</a></li>
                    <li><a href="#about">About</a></li>
                    <li><a href="#tickets">Tickets</a></li>
                    <li><a href="#contact">Contact</a></li>
                    <li><a href="#book" class="btn-primary">Book Now</a></li>
                </ul>
                <div class="mobile-menu-btn">
                    <i class="fas fa-bars"></i>
                </div>
            </nav>
        </div>
    </header>

    <!-- Hero Section -->
    <section id="home" class="hero">
        <div class="container">
            <h1 class="animate-up">CALABAR DAY 2026</h1>
            <h3 style="color: var(--secondary-color);">August 15th, 2026</h3>
            <p class="animate-up delay-1">Fundraising for Proposed Calabar Community House UK</p>
            <a href="#book" class="btn-primary animate-up delay-2">Get Tickets</a>

            <!-- Countdown Timer -->
            <div id="countdown" class="countdown animate-up delay-3">
                <div class="time-box">
                    <span id="days">00</span>
                    <label>Days</label>
                </div>
                <div class="time-box">
                    <span id="hours">00</span>
                    <label>Hours</label>
                </div>
                <div class="time-box">
                    <span id="minutes">00</span>
                    <label>Minutes</label>
                </div>
                <div class="time-box">
                    <span id="seconds">00</span>
                    <label>Seconds</label>
                </div>
            </div>
        </div>
    </section>

    <!-- About Section -->
    <section id="about">
        <div class="container">
            <h2 class="section-title">About The Event</h2>
            <div class="about-content" style="text-align: center; max-width: 800px; margin: 0 auto;">
                <p>You are cordially invited to our grand celebration designated to support the **Proposed Calabar Community House UK**. We aim to raise <strong>£1,200,000.00</strong>.</p>
                <div style="margin-top: 2rem; display: flex; justify-content: center; gap: 2rem; flex-wrap: wrap;">
                    <div class="info-card">
                        <i class="fas fa-map-marker-alt" style="font-size: 2rem; color: var(--secondary-color); margin-bottom: 1rem;"></i>
                        <h3>Venue</h3>
                        <p>The City Pavilion,<br>Collier Row Rd, Romford,<br>London RM5 2BH</p>
                    </div>
                    <div class="info-card">
                        <i class="fas fa-clock" style="font-size: 2rem; color: var(--secondary-color); margin-bottom: 1rem;"></i>
                        <h3>Time</h3>
                        <p>3:00 PM – 11:30 PM</p>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Tickets Section -->
    <section id="tickets">
        <div class="container">
            <h2 class="section-title">Ticket Pricing</h2>
            <div class="tickets-grid">
                <!-- Adult Ticket -->
                <div class="ticket-card">
                    <h3>Adult Ticket</h3>
                    <div class="ticket-price">£60</div>
                    <ul class="ticket-features">
                        <li>Full Event Access</li>
                        <li>Dinner Included</li>
                        <li>Live Entertainment</li>
                    </ul>
                    <button class="btn-primary select-ticket-btn" onclick="scrollToBooking('adult')">Select</button>
                </div>

                <!-- Child (10-17) -->
                <div class="ticket-card">
                    <h3>Teen Ticket (10-17)</h3>
                    <div class="ticket-price">£20</div>
                    <ul class="ticket-features">
                        <li>Event Access</li>
                        <li>Refreshments</li>
                        <li>Discounted Rate</li>
                    </ul>
                    <button class="btn-primary select-ticket-btn" onclick="scrollToBooking('child_teen')">Select</button>
                </div>

                <!-- Child (0-9) -->
                <div class="ticket-card">
                    <h3>Child (0-9)</h3>
                    <div class="ticket-price">Free</div>
                    <ul class="ticket-features">
                        <li>Free Entry</li>
                        <li>Kids Zone Access</li>
                        <li>Must be accompanied</li>
                    </ul>
                    <button class="btn-primary select-ticket-btn" onclick="scrollToBooking('child_free')">Select</button>
                </div>
            </div>
        </div>
    </section>

    <!-- Booking Section -->
    <section id="book" style="background: rgba(0,0,0,0.2);">
        <div class="container">
            <h2 class="section-title">Secure Your Spot</h2>
            <form action="secure/submit/booking" method="POST" class="booking-form" id="bookingForm">
                <input type="hidden" name="csrf_token" value="<?php echo $_SESSION['csrf_token']; ?>">
                
                <h3 style="margin-bottom: 1.5rem; text-align: center; color: var(--secondary-color);">Registration Form</h3>

                <!-- Personal Details -->
                <div class="form-group">
                    <label>Full Name</label>
                    <input type="text" name="full_name" class="form-control" required placeholder="John Doe">
                </div>
                <div class="form-group">
                    <label>Email Address</label>
                    <input type="email" name="email" class="form-control" required placeholder="john@example.com">
                </div>
                <div class="form-group">
                    <label>Phone Number</label>
                    <input type="tel" name="phone" class="form-control" required placeholder="+44 7000 000000">
                </div>
                <div class="form-group">
                    <label>Address (Optional)</label>
                    <textarea name="address" class="form-control" placeholder="Your Address"></textarea>
                </div>

                <!-- Ticket Selection -->
                <h4 style="margin: 2rem 0 1rem; border-bottom: 1px solid rgba(255,255,255,0.1); padding-bottom: 0.5rem;">Select Tickets</h4>
                
                <div class="form-group" style="display: flex; justify-content: space-between; align-items: center;">
                    <label>Adult Tickets (£60)</label>
                    <input type="number" name="tickets[adult]" id="ticket_adult" class="form-control" style="width: 80px;" min="0" value="0" onchange="calculateTotal()">
                </div>
                <div class="form-group" style="display: flex; justify-content: space-between; align-items: center;">
                    <label>Teen Tickets (10-17) (£20)</label>
                    <input type="number" name="tickets[child_teen]" id="ticket_child_teen" class="form-control" style="width: 80px;" min="0" value="0" onchange="calculateTotal()">
                </div>
                <div class="form-group" style="display: flex; justify-content: space-between; align-items: center;">
                    <label>Child (0-9) (Free)</label>
                    <input type="number" name="tickets[child_free]" id="ticket_child_free" class="form-control" style="width: 80px;" min="0" value="0">
                </div>

                <!-- Total -->
                <div style="margin-top: 2rem; text-align: right; font-size: 1.5rem; font-weight: bold; color: var(--secondary-color);">
                    Total: £<span id="totalAmount">0</span>
                </div>

                <div style="margin-top: 2rem; text-align: center;">
                    <button type="submit" class="btn-primary" style="width: 100%; font-size: 1.2rem;">Proceed to Payment</button>
                    <p style="font-size: 0.8rem; margin-top: 1rem; opacity: 0.6;"><i class="fas fa-lock"></i> Secured by Stripe SSL Encryption</p>
                </div>
            </form>
        </div>
    </section>

    <!-- Map & Contact -->
    <section id="contact">
        <div class="container">
            <h2 class="section-title">Contact & Location</h2>
            <div class="contact-grid" style="display: grid; grid-template-columns: 1fr 1fr; gap: 2rem;">
                <!-- Map -->
                <div class="map-container" style="border-radius: 15px; overflow: hidden; height: 400px;">
                    <iframe 
                        src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d2479.284218329668!2d0.1587823157743588!3d51.58151297964724!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x47d8a4e8d3840e69%3A0x6335193910542385!2sThe%20City%20Pavilion!5e0!3m2!1sen!2suk!4v1629810000000!5m2!1sen!2suk" 
                        width="100%" height="100%" style="border:0;" allowfullscreen="" loading="lazy">
                    </iframe>
                </div>
                
                <!-- Contact Info -->
                <div class="contact-info" style="display: flex; flex-direction: column; justify-content: center;">
                    <h3>Contact Persons</h3>
                    <ul style="list-style: none; font-size: 1.2rem; margin-top: 1rem;">
                        <li style="margin-bottom: 1rem;"><i class="fas fa-phone-alt" style="color: var(--secondary-color); margin-right: 10px;"></i> +44 7368 450477</li>
                        <li style="margin-bottom: 1rem;"><i class="fas fa-phone-alt" style="color: var(--secondary-color); margin-right: 10px;"></i> +44 7484 781103</li>
                        <li style="margin-bottom: 1rem;"><i class="fas fa-phone-alt" style="color: var(--secondary-color); margin-right: 10px;"></i> +44 7958 516658</li>
                    </ul>
                    <div style="margin-top: 2rem; padding: 1rem; background: rgba(255,255,255,0.05); border-left: 3px solid var(--secondary-color);">
                        <h4>Bank Transfer Alternative</h4>
                        <p><strong>Calabar Community UK</strong></p>
                        <p><strong>Bank Natwest</strong></p>
                        <p>Sort Code: 56-00-47</p>
                        <p>Account: 38688662</p>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <footer>
        <div class="container">
            <div class="social-links">
                <a href="#"><i class="fab fa-facebook"></i></a>
                <a href="#"><i class="fab fa-twitter"></i></a>
                <a href="#"><i class="fab fa-instagram"></i></a>
            </div>
            <p>&copy; 2026 Calabar Community UK. All Rights Reserved. Powered by <a href="https://www.onielng.com" target="_blank">O'niel Soft Innovation Limited</a> </p>
        </div>
    </footer>

    <script src="assets/js/script.js"></script>
</body>
</html>
