// Set the date we're counting down to
// Using a placeholder date: Saturday, July 25, 2026
// Set the date we're counting down to
const countDownDate = new Date("Aug 15, 2026 15:00:00").getTime();

// Update the count down every 1 second
const x = setInterval(function () {

    // Get today's date and time
    const now = new Date().getTime();

    // Find the distance between now and the count down date
    const distance = countDownDate - now;

    // Time calculations for days, hours, minutes and seconds
    const days = Math.floor(distance / (1000 * 60 * 60 * 24));
    const hours = Math.floor((distance % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
    const minutes = Math.floor((distance % (1000 * 60 * 60)) / (1000 * 60));
    const seconds = Math.floor((distance % (1000 * 60)) / 1000);

    // Display the result in the elements
    document.getElementById("days").innerHTML = days;
    document.getElementById("hours").innerHTML = hours;
    document.getElementById("minutes").innerHTML = minutes;
    document.getElementById("seconds").innerHTML = seconds;

    // If the count down is finished, write some text
    if (distance < 0) {
        clearInterval(x);
        document.getElementById("countdown").innerHTML = "EXPIRED";
    }
}, 1000);

// Navbar Scroll Effect
window.addEventListener('scroll', function () {
    const header = document.querySelector('header');
    if (window.scrollY > 50) {
        header.style.background = 'rgba(26, 11, 46, 0.98)';
        header.style.padding = '0.5rem 0';
    } else {
        header.style.background = 'rgba(26, 11, 46, 0.95)';
        header.style.padding = '1rem 0';
    }
});

// Calculate Total Cost
function calculateTotal() {
    const adultPrice = 60;
    const childTeenPrice = 20;
    const childFreePrice = 0;

    const adultQty = parseInt(document.getElementById('ticket_adult').value) || 0;
    const childTeenQty = parseInt(document.getElementById('ticket_child_teen').value) || 0;
    const childFreeQty = parseInt(document.getElementById('ticket_child_child_free') ? document.getElementById('ticket_child_child_free').value : 0) || 0;

    const total = (adultQty * adultPrice) + (childTeenQty * childTeenPrice) + (childFreeQty * childFreePrice);

    document.getElementById('totalAmount').innerText = total;
}

// Ensure the calculateTotal runs when inputs change
document.getElementById('ticket_adult').addEventListener('input', calculateTotal);
document.getElementById('ticket_child_teen').addEventListener('input', calculateTotal);
// Note: Child (0-9) input ID in calculateTotal was slightly different than HTML. Correcting it here.
const freeTicketInput = document.getElementById('ticket_child_free');
if (freeTicketInput) {
    freeTicketInput.addEventListener('input', calculateTotal);
}


// Scroll to Booking and Pre-fill
function scrollToBooking(type) {
    const bookingSection = document.getElementById('book');
    bookingSection.scrollIntoView({ behavior: 'smooth' });

    // Reset values first
    document.getElementById('ticket_adult').value = 0;
    document.getElementById('ticket_child_teen').value = 0;
    if (document.getElementById('ticket_child_free')) document.getElementById('ticket_child_free').value = 0;

    // Set the selected type to 1
    if (type === 'adult') {
        document.getElementById('ticket_adult').value = 1;
    } else if (type === 'child_teen') {
        document.getElementById('ticket_child_teen').value = 1;
    } else if (type === 'child_free') {
        document.getElementById('ticket_child_free').value = 1;
    }

    calculateTotal();
}
