<?php
session_start();
include '../includes/db_connect.php';

if (!isset($_SESSION['admin_logged_in'])) {
    http_response_code(403);
    exit();
}

$query = isset($_GET['q']) ? trim($_GET['q']) : '';

if (strlen($query) < 3) {
    echo json_encode([]);
    exit();
}

try {
    // Search for ticket codes ending with the query or containing the query
    // Optimizing for "last 5 digits" preference but allowing general partial matches
    $stmt = $pdo->prepare("SELECT ticket_code, status FROM tickets WHERE ticket_code LIKE ? LIMIT 10");
    $stmt->execute(["%$query"]);
    $results = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    echo json_encode($results);
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['error' => $e->getMessage()]);
}
?>
