<?php
session_start();
include '../includes/db_connect.php';

if (!isset($_SESSION['admin_logged_in'])) {
    header("Location: ../manager/auth");
    exit();
}

// Fetch all bookings with ticket info
// Note: This query joins bookings and tickets to get a flat list of attendees
$sql = "SELECT b.booking_ref, b.full_name, b.email, b.phone, t.ticket_type, t.ticket_code, b.total_amount, b.payment_status 
        FROM bookings b 
        LEFT JOIN tickets t ON b.id = t.booking_id 
        ORDER BY b.date_created DESC";

$stmt = $pdo->query($sql);
$rows = $stmt->fetchAll(PDO::FETCH_ASSOC);

$filename = "calabar_bookings_" . date('Y-m-d') . ".csv";

header('Content-Type: text/csv');
header('Content-Disposition: attachment; filename="' . $filename . '"');

$output = fopen('php://output', 'w');
fputcsv($output, ['Booking Ref', 'Full Name', 'Email', 'Phone', 'Ticket Type', 'Ticket Code', 'Total Amount', 'Payment Status']);

foreach ($rows as $row) {
    fputcsv($output, $row);
}
fclose($output);
?>
