<?php
session_start();
include '../includes/db_connect.php';

if (!isset($_SESSION['admin_logged_in'])) {
    header("Location: index.php");
    exit();
}

// Ensure correct date format for 'date_created' (using DATETIME in setup_db but outputting formatted)
// 1. Total Stats
$totalTicketsStmt = $pdo->query("SELECT COUNT(*) FROM tickets WHERE status != 'cancelled'");
$totalTickets = $totalTicketsStmt->fetchColumn();

// Total Revenue (Sum of paid bookings or sum of tickets?)
// Using bookings total_amount for simplicity as it includes the aggregate
$revenueStmt = $pdo->query("SELECT SUM(total_amount) FROM bookings WHERE payment_status = 'paid'");
$totalRevenue = $revenueStmt->fetchColumn() ?: 0;

// Breakdown
$breakdownStmt = $pdo->query("SELECT ticket_type, COUNT(*) as count FROM tickets WHERE status != 'cancelled' GROUP BY ticket_type");
$breakdown = $breakdownStmt->fetchAll(PDO::FETCH_KEY_PAIR);

// Recent Bookings
$bookingsStmt = $pdo->query("SELECT * FROM bookings ORDER BY date_created DESC LIMIT 10");
$recentBookings = $bookingsStmt->fetchAll();

// Handle Edit Limit
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['update_limit'])) {
    $newLimit = (int)$_POST['total_tickets'];
    if ($newLimit > 0) {
        $stmt = $pdo->prepare("UPDATE settings SET setting_value = ? WHERE setting_key = 'total_tickets'");
        $stmt->execute([$newLimit]);
        echo "<script>alert('Ticket Limit Updated!'); window.location.href='dashboard.php';</script>";
    }
}

// Get Total Ticket Limit
$limitStmt = $pdo->query("SELECT setting_value FROM settings WHERE setting_key = 'total_tickets'");
$limitRow = $limitStmt->fetch();
$totalTicketLimit = $limitRow ? (int)$limitRow['setting_value'] : 800; // Default fallback

// Updated Calculation
$remainingTickets = $totalTicketLimit - $totalTickets;

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Admin Dashboard - Calabar Day</title>
    <link rel="stylesheet" href="../assets/css/style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        body { padding-top: 80px; }
        .dashboard-grid { 
            display: grid; 
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr)); 
            gap: 20px; 
            margin-bottom: 40px; 
        }
        .stat-card { 
            background: rgba(255,255,255,0.05); 
            padding: 20px; 
            border-radius: 10px; 
            border: 1px solid rgba(255,255,255,0.1); 
            text-align: center;
        }
        .stat-value { font-size: 2.5rem; color: var(--secondary-color); font-weight: bold; }
        .stat-label { font-size: 1rem; opacity: 0.7; }
        
        table { width: 100%; border-collapse: collapse; margin-top: 20px; background: rgba(0,0,0,0.2); }
        th, td { padding: 15px; text-align: left; border-bottom: 1px solid rgba(255,255,255,0.1); }
        th { background: rgba(255,255,255,0.1); color: var(--secondary-color); }
        tr:hover { background: rgba(255,255,255,0.05); }
        
        .status-paid { color: #4CAF50; font-weight: bold; }
        .status-pending { color: #FFC107; font-weight: bold; }
        .status-failed { color: #F44336; font-weight: bold; }
        
        .btn-sm { padding: 5px 10px; font-size: 0.8rem; }
        
        /* New Update Limit Form */
        .limit-form {
            background: rgba(0,0,0,0.3);
            padding: 15px;
            border-radius: 8px;
            margin-top: 10px;
            display: inline-block;
        }
    </style>
</head>
<body>
    
    <header>
        <div class="container nav-content">
            <nav>
                <a href="#" class="logo">ADMIN<span style="color: #fff;">PANEL</span></a>
                <ul class="nav-links">
                    <li><a href="../manager/panel" class="active">Dashboard</a></li>
                    <li><a href="../manager/scanner">QR Scanner</a></li> 
                    <li><a href="../manager/exit">Logout</a></li>
                </ul>
            </nav>
        </div>
    </header>

    <div class="container">
        <div style="display: flex; justify-content: space-between; align-items: start; margin-bottom: 2rem; flex-wrap: wrap; gap: 20px;"> 
            <div>
                <h2>Overview</h2>
                <div class="limit-form">
                    <form method="POST" action="../manager/panel" style="display: flex; gap: 10px; align-items: center;">
                        <label>Total Capacity:</label>
                        <input type="number" name="total_tickets" value="<?php echo $totalTicketLimit; ?>" style="width: 80px; padding: 5px;">
                        <button type="submit" name="update_limit" class="btn-primary" style="padding: 5px 15px; font-size: 0.9rem;">Update</button>
                    </form>
                </div>
            </div>
            <a href="../manager/export" class="btn-primary btn-sm"><i class="fas fa-file-excel"></i> Export CSV</a>
        </div>
        
        <div class="dashboard-grid">
            <div class="stat-card">
                <div class="stat-value"><?php echo $totalTickets; ?> / <?php echo $totalTicketLimit; ?></div>
                <div class="stat-label">Tickets Sold</div>
                <div style="margin-top: 5px; font-size: 0.9rem; color: #aaa;">Remaining: <?php echo $remainingTickets; ?></div>
            </div>
            <div class="stat-card">
                <div class="stat-value">£<?php echo number_format($totalRevenue, 2); ?></div>
                <div class="stat-label">Total Revenue</div>
            </div>
            <div class="stat-card">
                <div style="text-align: left; padding-left: 20px;">
                    <?php foreach($breakdown as $type => $count): ?>
                        <div><?php echo $type; ?>: <b style="color: #fff;"><?php echo $count; ?></b></div>
                    <?php endforeach; ?>
                    <?php if(empty($breakdown)) echo "No tickets sold yet."; ?>
                </div>
                <div class="stat-label" style="margin-top: 10px;">Ticket Breakdown</div>
            </div>
        </div>

        <h3>Recent Bookings</h3>
        <table>
            <thead>
                <tr>
                    <th>Ref</th>
                    <th>Name</th>
                    <th>Email</th>
                    <th>Date</th>
                    <th>Tickets</th>
                    <th>Amount</th>
                    <th>Status</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach($recentBookings as $b): 
                    // Fetch ticket summary for this booking
                    $tStmt = $pdo->prepare("SELECT ticket_type, COUNT(*) as qty FROM tickets WHERE booking_id = ? GROUP BY ticket_type");
                    $tStmt->execute([$b['id']]);
                    $ticketCounts = $tStmt->fetchAll(PDO::FETCH_KEY_PAIR);
                    $ticketSummary = [];
                    foreach($ticketCounts as $type => $qty) {
                        $ticketSummary[] = "<b>$qty</b> x $type";
                    }
                    $ticketDisplay = !empty($ticketSummary) ? implode('<br>', $ticketSummary) : '<span style="color:#888;">No tickets</span>';
                ?>
                <tr>
                    <td><?php echo $b['booking_ref']; ?></td>
                    <td><?php echo htmlspecialchars($b['full_name']); ?></td>
                    <td><?php echo htmlspecialchars($b['email']); ?></td>
                    <td><?php echo date('M d, Y H:i', strtotime($b['date_created'])); ?></td>
                    <td><?php echo $ticketDisplay; ?></td>
                    <td>£<?php echo number_format($b['total_amount'], 2); ?></td>
                    <td><span class="status-<?php echo $b['payment_status']; ?>"><?php echo ucfirst($b['payment_status']); ?></span></td>
                </tr>
                <?php endforeach; ?>
                <?php if(empty($recentBookings)) echo "<tr><td colspan='7' style='text-align:center;'>No bookings found.</td></tr>"; ?>
            </tbody>
        </table>
    </div>
</body>
</html>
