# Calabar Day 2026 - Event Booking System

A professional, high-end event registration system built with PHP, MySQL, and Vanilla CSS.

## Features
- **Modern UI**: Dark purple & Gold luxury theme with glassmorphism effects.
- **Dynamic Booking**: Multi-ticket selection with real-time total calculation.
- **Secure Payment Flow**: Mock Stripe integration with secure simulated transactions.
- **Ticket Generation**: Automatic generation of unique ticket codes and QR codes.
- **Admin Dashboard**: Real-time sales tracking, attendee management, and CSV export.
- **QR Scanning**: Admin tool for validating tickets at the venue.

## Setup Instructions

1.  **Database Setup**:
    -   Ensure your XAMPP Apache and MySQL servers are running.
    -   Open your browser and navigate to `http://localhost/cdevent/setup_database.php`.
    -   This script will automatically create the `calabar_event_db` database and all required tables.
    -   **Default Admin Credentials**:
        -   Username: `Admin`
        -   Password: `Admin@123`

2.  **Running the Application**:
    -   **User Portal**: Go to `http://localhost/cdevent/index.php`.
    -   **Admin Panel**: Go to `http://localhost/cdevent/admin/index.php`.

## Project Structure
-   `index.php`: Main landing page with booking form.
-   `admin/`: Contains dashboard, login, and scanner tools.
-   `includes/`: Database connection and helper functions.
-   `assets/`: CSS styles, JS scripts, and images.

## Security Note
This application uses secure practices including:
-   PDO Prepared Statements (SQL Injection prevention).
-   CSRF Tokens (Cross-Site Request Forgery protection).
-   Password Hashing (Argon2i/BCrypt).
-   Input Sanitization.
